/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.coapserver;

import java.net.InetSocketAddress;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.coapserver.TbCoapDtlsSessionInMemoryStorage;
import org.thingsboard.server.coapserver.TbCoapDtlsSessionInfo;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.msg.EncryptionUtil;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.common.transport.util.SslUtil;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;

public class TbCoapDtlsCertificateVerifier
implements NewAdvancedCertificateVerifier {
    private static final Logger log = LoggerFactory.getLogger(TbCoapDtlsCertificateVerifier.class);
    private final TbCoapDtlsSessionInMemoryStorage tbCoapDtlsSessionInMemoryStorage;
    private TransportService transportService;
    private TbServiceInfoProvider serviceInfoProvider;
    private boolean skipValidityCheckForClientCert;

    public TbCoapDtlsCertificateVerifier(TransportService transportService, TbServiceInfoProvider serviceInfoProvider, long dtlsSessionInactivityTimeout, long dtlsSessionReportTimeout, boolean skipValidityCheckForClientCert) {
        this.transportService = transportService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.skipValidityCheckForClientCert = skipValidityCheckForClientCert;
        this.tbCoapDtlsSessionInMemoryStorage = new TbCoapDtlsSessionInMemoryStorage(dtlsSessionInactivityTimeout, dtlsSessionReportTimeout);
    }

    public List<CertificateType> getSupportedCertificateTypes() {
        return Collections.singletonList(CertificateType.X_509);
    }

    public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, InetSocketAddress remotePeer, boolean clientUsage, boolean verifySubject, boolean truncateCertificatePath, CertificateMessage message) {
        try {
            X509Certificate[] chain;
            CertPath certpath = message.getCertificateChain();
            for (X509Certificate cert : chain = certpath.getCertificates().toArray(new X509Certificate[0])) {
                try {
                    if (!this.skipValidityCheckForClientCert) {
                        cert.checkValidity();
                    }
                    String strCert = SslUtil.getCertificateString((Certificate)cert);
                    String sha3Hash = EncryptionUtil.getSha3Hash((String)strCert);
                    final ValidateDeviceCredentialsResponse[] deviceCredentialsResponse = new ValidateDeviceCredentialsResponse[1];
                    final CountDownLatch latch = new CountDownLatch(1);
                    this.transportService.process(DeviceTransportType.COAP, TransportProtos.ValidateDeviceX509CertRequestMsg.newBuilder().setHash(sha3Hash).build(), (TransportServiceCallback)new TransportServiceCallback<ValidateDeviceCredentialsResponse>(){

                        public void onSuccess(ValidateDeviceCredentialsResponse msg) {
                            if (!StringUtils.isEmpty((String)msg.getCredentials())) {
                                deviceCredentialsResponse[0] = msg;
                            }
                            latch.countDown();
                        }

                        public void onError(Throwable e) {
                            log.error(e.getMessage(), e);
                            latch.countDown();
                        }
                    });
                    latch.await(10L, TimeUnit.SECONDS);
                    ValidateDeviceCredentialsResponse msg = deviceCredentialsResponse[0];
                    if (msg == null || !strCert.equals(msg.getCredentials())) continue;
                    DeviceProfile deviceProfile = msg.getDeviceProfile();
                    if (!msg.hasDeviceInfo() || deviceProfile == null) break;
                    this.tbCoapDtlsSessionInMemoryStorage.put(remotePeer, new TbCoapDtlsSessionInfo(msg, deviceProfile));
                    break;
                }
                catch (InterruptedException | CertificateEncodingException | CertificateExpiredException | CertificateNotYetValidException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                    throw new HandshakeException("Certificate chain could not be validated", alert);
                }
            }
            return new CertificateVerificationResult(cid, certpath, null);
        }
        catch (HandshakeException e) {
            log.trace("Certificate validation failed!", (Throwable)e);
            return new CertificateVerificationResult(cid, e, null);
        }
    }

    public List<X500Principal> getAcceptedIssuers() {
        return CertPathUtil.toSubjects(null);
    }

    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    public ConcurrentMap<InetSocketAddress, TbCoapDtlsSessionInfo> getTbCoapDtlsSessionsMap() {
        return this.tbCoapDtlsSessionInMemoryStorage.getDtlsSessionsMap();
    }

    public void evictTimeoutSessions() {
        this.tbCoapDtlsSessionInMemoryStorage.evictTimeoutSessions();
    }

    public long getDtlsSessionReportTimeout() {
        return this.tbCoapDtlsSessionInMemoryStorage.getDtlsSessionReportTimeout();
    }

    public TbCoapDtlsSessionInMemoryStorage getTbCoapDtlsSessionInMemoryStorage() {
        return this.tbCoapDtlsSessionInMemoryStorage;
    }

    public TransportService getTransportService() {
        return this.transportService;
    }

    public TbServiceInfoProvider getServiceInfoProvider() {
        return this.serviceInfoProvider;
    }

    public boolean isSkipValidityCheckForClientCert() {
        return this.skipValidityCheckForClientCert;
    }

    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    public void setServiceInfoProvider(TbServiceInfoProvider serviceInfoProvider) {
        this.serviceInfoProvider = serviceInfoProvider;
    }

    public void setSkipValidityCheckForClientCert(boolean skipValidityCheckForClientCert) {
        this.skipValidityCheckForClientCert = skipValidityCheckForClientCert;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbCoapDtlsCertificateVerifier)) {
            return false;
        }
        TbCoapDtlsCertificateVerifier other = (TbCoapDtlsCertificateVerifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSkipValidityCheckForClientCert() != other.isSkipValidityCheckForClientCert()) {
            return false;
        }
        TbCoapDtlsSessionInMemoryStorage this$tbCoapDtlsSessionInMemoryStorage = this.getTbCoapDtlsSessionInMemoryStorage();
        TbCoapDtlsSessionInMemoryStorage other$tbCoapDtlsSessionInMemoryStorage = other.getTbCoapDtlsSessionInMemoryStorage();
        if (this$tbCoapDtlsSessionInMemoryStorage == null ? other$tbCoapDtlsSessionInMemoryStorage != null : !((Object)this$tbCoapDtlsSessionInMemoryStorage).equals(other$tbCoapDtlsSessionInMemoryStorage)) {
            return false;
        }
        TransportService this$transportService = this.getTransportService();
        TransportService other$transportService = other.getTransportService();
        if (this$transportService == null ? other$transportService != null : !this$transportService.equals(other$transportService)) {
            return false;
        }
        TbServiceInfoProvider this$serviceInfoProvider = this.getServiceInfoProvider();
        TbServiceInfoProvider other$serviceInfoProvider = other.getServiceInfoProvider();
        return !(this$serviceInfoProvider == null ? other$serviceInfoProvider != null : !this$serviceInfoProvider.equals(other$serviceInfoProvider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbCoapDtlsCertificateVerifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSkipValidityCheckForClientCert() ? 79 : 97);
        TbCoapDtlsSessionInMemoryStorage $tbCoapDtlsSessionInMemoryStorage = this.getTbCoapDtlsSessionInMemoryStorage();
        result = result * 59 + ($tbCoapDtlsSessionInMemoryStorage == null ? 43 : ((Object)$tbCoapDtlsSessionInMemoryStorage).hashCode());
        TransportService $transportService = this.getTransportService();
        result = result * 59 + ($transportService == null ? 43 : $transportService.hashCode());
        TbServiceInfoProvider $serviceInfoProvider = this.getServiceInfoProvider();
        result = result * 59 + ($serviceInfoProvider == null ? 43 : $serviceInfoProvider.hashCode());
        return result;
    }

    public String toString() {
        return "TbCoapDtlsCertificateVerifier(tbCoapDtlsSessionInMemoryStorage=" + String.valueOf(this.getTbCoapDtlsSessionInMemoryStorage()) + ", transportService=" + String.valueOf(this.getTransportService()) + ", serviceInfoProvider=" + String.valueOf(this.getServiceInfoProvider()) + ", skipValidityCheckForClientCert=" + this.isSkipValidityCheckForClientCert() + ")";
    }
}

