/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.coapserver;

import java.util.List;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.DelivererException;
import org.eclipse.californium.core.server.ServerMessageDeliverer;
import org.eclipse.californium.core.server.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TbCoapServerMessageDeliverer
extends ServerMessageDeliverer {
    private static final Logger log = LoggerFactory.getLogger(TbCoapServerMessageDeliverer.class);

    public TbCoapServerMessageDeliverer(Resource root) {
        super(root);
    }

    protected Resource findResource(Exchange exchange) throws DelivererException {
        this.validateUriPath(exchange);
        return this.findResource(exchange.getRequest().getOptions().getUriPath());
    }

    private void validateUriPath(Exchange exchange) {
        OptionSet options = exchange.getRequest().getOptions();
        List uriPathList = options.getUriPath();
        String path = this.toPath(uriPathList);
        if (path != null) {
            options.setUriPath(path);
            exchange.getRequest().setOptions(options);
        }
    }

    private String toPath(List<String> list) {
        if (!CollectionUtils.isEmpty(list) && list.size() == 1) {
            String slash = "/";
            String path = list.get(0);
            if (path.startsWith("/")) {
                path = path.substring("/".length());
            }
            return path;
        }
        return null;
    }
}

