/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.coapserver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.thingsboard.server.coapserver.TbCoapDtlsCertificateVerifier;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.config.ssl.SslCredentials;
import org.thingsboard.server.common.transport.config.ssl.SslCredentialsConfig;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;

@ConditionalOnProperty(prefix="coap.dtls", value={"enabled"}, havingValue="true")
@Component
public class TbCoapDtlsSettings {
    private static final Logger log = LoggerFactory.getLogger(TbCoapDtlsSettings.class);
    @Value(value="${coap.dtls.bind_address}")
    private String host;
    @Value(value="${coap.dtls.bind_port}")
    private Integer port;
    @Value(value="${transport.coap.dtls.retransmission_timeout:9000}")
    private int dtlsRetransmissionTimeout;
    @Autowired
    @Qualifier(value="coapDtlsCredentials")
    private SslCredentialsConfig coapDtlsCredentialsConfig;
    @Value(value="${coap.dtls.x509.skip_validity_check_for_client_cert:false}")
    private boolean skipValidityCheckForClientCert;
    @Value(value="${coap.dtls.x509.dtls_session_inactivity_timeout:86400000}")
    private long dtlsSessionInactivityTimeout;
    @Value(value="${coap.dtls.x509.dtls_session_report_timeout:1800000}")
    private long dtlsSessionReportTimeout;
    @Autowired(required=false)
    private TransportService transportService;
    @Autowired(required=false)
    private TbServiceInfoProvider serviceInfoProvider;

    @Bean
    @ConfigurationProperties(prefix="coap.dtls.credentials")
    public SslCredentialsConfig coapDtlsCredentials() {
        return new SslCredentialsConfig("COAP DTLS Credentials", false);
    }

    public DtlsConnectorConfig dtlsConnectorConfig(Configuration configuration) throws UnknownHostException {
        DtlsConnectorConfig.Builder configBuilder = new DtlsConnectorConfig.Builder(configuration);
        configBuilder.setAddress(this.getInetSocketAddress());
        SslCredentials sslCredentials = this.coapDtlsCredentialsConfig.getCredentials();
        SslContextUtil.Credentials serverCredentials = new SslContextUtil.Credentials(sslCredentials.getPrivateKey(), null, sslCredentials.getCertificateChain());
        configBuilder.set((BasicDefinition)DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.WANTED);
        configBuilder.set(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, this.dtlsRetransmissionTimeout, TimeUnit.MILLISECONDS);
        configBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.SERVER_ONLY);
        configBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new TbCoapDtlsCertificateVerifier(this.transportService, this.serviceInfoProvider, this.dtlsSessionInactivityTimeout, this.dtlsSessionReportTimeout, this.skipValidityCheckForClientCert));
        configBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(serverCredentials.getPrivateKey(), (Certificate[])serverCredentials.getCertificateChain(), Collections.singletonList(CertificateType.X_509)));
        return configBuilder.build();
    }

    private InetSocketAddress getInetSocketAddress() throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(this.host);
        return new InetSocketAddress(addr, (int)this.port);
    }
}

