/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cluster;

import java.util.UUID;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.edge.EdgeEventUpdateMsg;
import org.thingsboard.server.common.msg.edge.EdgeHighPriorityMsg;
import org.thingsboard.server.common.msg.edge.FromEdgeSyncResponse;
import org.thingsboard.server.common.msg.edge.ToEdgeSyncRequest;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueClusterService;

public interface TbClusterService
extends TbQueueClusterService {
    public void pushMsgToCore(TopicPartitionInfo var1, UUID var2, TransportProtos.ToCoreMsg var3, TbQueueCallback var4);

    public void pushMsgToCore(TenantId var1, EntityId var2, TransportProtos.ToCoreMsg var3, TbQueueCallback var4);

    public void pushMsgToCore(ToDeviceActorNotificationMsg var1, TbQueueCallback var2);

    public void broadcastToCore(TransportProtos.ToCoreNotificationMsg var1);

    public void broadcastToCalculatedFields(TransportProtos.ToCalculatedFieldNotificationMsg var1, TbQueueCallback var2);

    public void pushMsgToVersionControl(TenantId var1, TransportProtos.ToVersionControlServiceMsg var2, TbQueueCallback var3);

    public void pushNotificationToCore(String var1, IntegrationDownlinkMsg var2, TbQueueCallback var3);

    public void pushNotificationToCore(String var1, FromDeviceRpcResponse var2, TbQueueCallback var3);

    public void pushNotificationToCore(String var1, TransportProtos.RestApiCallResponseMsgProto var2, TbQueueCallback var3);

    public void pushMsgToRuleEngine(TopicPartitionInfo var1, UUID var2, TransportProtos.ToRuleEngineMsg var3, TbQueueCallback var4);

    public void pushMsgToRuleEngine(TenantId var1, EntityId var2, TbMsg var3, TbQueueCallback var4);

    public void pushMsgToRuleEngine(TenantId var1, EntityId var2, TbMsg var3, boolean var4, TbQueueCallback var5);

    public void pushNotificationToRuleEngine(String var1, FromDeviceRpcResponse var2, TbQueueCallback var3);

    public void pushNotificationToTransport(String var1, TransportProtos.ToTransportMsg var2, TbQueueCallback var3);

    public void pushMsgToCalculatedFields(TenantId var1, EntityId var2, TransportProtos.ToCalculatedFieldMsg var3, TbQueueCallback var4);

    public void pushMsgToCalculatedFields(TopicPartitionInfo var1, UUID var2, TransportProtos.ToCalculatedFieldMsg var3, TbQueueCallback var4);

    public void broadcastEntityStateChangeEvent(TenantId var1, EntityId var2, ComponentLifecycleEvent var3);

    public void broadcast(ComponentLifecycleMsg var1);

    public void onDeviceProfileChange(DeviceProfile var1, DeviceProfile var2, TbQueueCallback var3);

    public void onDeviceProfileDelete(DeviceProfile var1, TbQueueCallback var2);

    public void onTenantProfileChange(TenantProfile var1, TbQueueCallback var2);

    public void onTenantProfileDelete(TenantProfile var1, TbQueueCallback var2);

    public void onTenantChange(Tenant var1, TbQueueCallback var2);

    public void onTenantDelete(Tenant var1, TbQueueCallback var2);

    public void onApiStateChange(ApiUsageState var1, TbQueueCallback var2);

    public void onDeviceUpdated(Device var1, Device var2);

    public void onDeviceDeleted(TenantId var1, Device var2, TbQueueCallback var3);

    public void onDeviceAssignedToTenant(TenantId var1, Device var2);

    public void onAssetUpdated(Asset var1, Asset var2);

    public void onAssetDeleted(TenantId var1, Asset var2, TbQueueCallback var3);

    public void onResourceChange(TbResourceInfo var1, TbQueueCallback var2);

    public void onResourceDeleted(TbResourceInfo var1, TbQueueCallback var2);

    public void onEdgeHighPriorityMsg(EdgeHighPriorityMsg var1);

    public void onEdgeEventUpdate(EdgeEventUpdateMsg var1);

    public void onEdgeStateChangeEvent(ComponentLifecycleMsg var1);

    public void pushEdgeSyncRequestToEdge(ToEdgeSyncRequest var1);

    public void pushEdgeSyncResponseToCore(FromEdgeSyncResponse var1, String var2);

    public void pushMsgToEdge(TenantId var1, EntityId var2, TransportProtos.ToEdgeMsg var3, TbQueueCallback var4);

    public void sendNotificationMsgToEdge(TenantId var1, EdgeId var2, EntityId var3, String var4, EdgeEventType var5, EdgeEventActionType var6, EdgeId var7);

    public void sendNotificationMsgToEdge(TenantId var1, EdgeId var2, EntityId var3, String var4, EdgeEventType var5, EdgeEventActionType var6, EntityType var7, EntityGroupId var8, EdgeId var9);

    public void onUserUpdated(User var1, User var2);

    public void onCustomerUpdated(Customer var1, Customer var2);

    public void onCalculatedFieldUpdated(CalculatedField var1, CalculatedField var2, TbQueueCallback var3);

    public void onCalculatedFieldDeleted(CalculatedField var1, TbQueueCallback var2);
}

