/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cluster;

import java.util.UUID;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;

public interface TbClusterService {
    public void pushMsgToCore(TopicPartitionInfo var1, UUID var2, TransportProtos.ToCoreMsg var3, TbQueueCallback var4);

    public void pushMsgToCore(TenantId var1, EntityId var2, TransportProtos.ToCoreMsg var3, TbQueueCallback var4);

    public void pushMsgToCore(ToDeviceActorNotificationMsg var1, TbQueueCallback var2);

    public void pushNotificationToCore(String var1, FromDeviceRpcResponse var2, TbQueueCallback var3);

    public void pushMsgToRuleEngine(TopicPartitionInfo var1, UUID var2, TransportProtos.ToRuleEngineMsg var3, TbQueueCallback var4);

    public void pushMsgToRuleEngine(TenantId var1, EntityId var2, TbMsg var3, TbQueueCallback var4);

    public void pushNotificationToRuleEngine(String var1, FromDeviceRpcResponse var2, TbQueueCallback var3);

    public void pushNotificationToTransport(String var1, TransportProtos.ToTransportMsg var2, TbQueueCallback var3);

    public void broadcastEntityStateChangeEvent(TenantId var1, EntityId var2, ComponentLifecycleEvent var3);

    public void onDeviceProfileChange(DeviceProfile var1, TbQueueCallback var2);

    public void onDeviceProfileDelete(DeviceProfile var1, TbQueueCallback var2);

    public void onTenantProfileChange(TenantProfile var1, TbQueueCallback var2);

    public void onTenantProfileDelete(TenantProfile var1, TbQueueCallback var2);

    public void onTenantChange(Tenant var1, TbQueueCallback var2);

    public void onTenantDelete(Tenant var1, TbQueueCallback var2);

    public void onApiStateChange(ApiUsageState var1, TbQueueCallback var2);

    public void onDeviceUpdated(Device var1, Device var2);

    public void onDeviceUpdated(Device var1, Device var2, boolean var3);

    public void onDeviceDeleted(Device var1, TbQueueCallback var2);

    public void onResourceChange(TbResource var1, TbQueueCallback var2);

    public void onResourceDeleted(TbResource var1, TbQueueCallback var2);

    public void onEdgeEventUpdate(TenantId var1, EdgeId var2);

    public void sendNotificationMsgToEdgeService(TenantId var1, EdgeId var2, EntityId var3, String var4, EdgeEventType var5, EdgeEventActionType var6);
}

