/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache.ota;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cache.ota.OtaPackageDataCache;

@Service
@ConditionalOnProperty(prefix="cache", value={"type"}, havingValue="redis")
public class RedisOtaPackageDataCache
implements OtaPackageDataCache {
    private final RedisConnectionFactory redisConnectionFactory;

    @Override
    public byte[] get(String key) {
        return this.get(key, 0, 0);
    }

    @Override
    public byte[] get(String key, int chunkSize, int chunk) {
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            if (chunkSize == 0) {
                byte[] byArray = connection.get(this.toOtaPackageCacheKey(key));
                return byArray;
            }
            int startIndex = chunkSize * chunk;
            int endIndex = startIndex + chunkSize - 1;
            byte[] byArray = connection.getRange(this.toOtaPackageCacheKey(key), (long)startIndex, (long)endIndex);
            return byArray;
        }
    }

    @Override
    public void put(String key, byte[] value) {
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            connection.set(this.toOtaPackageCacheKey(key), value);
        }
    }

    @Override
    public void evict(String key) {
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            connection.del((byte[][])new byte[][]{this.toOtaPackageCacheKey(key)});
        }
    }

    private byte[] toOtaPackageCacheKey(String key) {
        return String.format("%s::%s", "otaPackagesData", key).getBytes();
    }

    @ConstructorProperties(value={"redisConnectionFactory"})
    @Generated
    public RedisOtaPackageDataCache(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }
}

