/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache.ota;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cache.ota.OtaPackageDataCache;

@Service
@ConditionalOnProperty(prefix="cache", value={"type"}, havingValue="caffeine", matchIfMissing=true)
public class CaffeineOtaPackageCache
implements OtaPackageDataCache {
    private final CacheManager cacheManager;

    @Override
    public byte[] get(String key) {
        return this.get(key, 0, 0);
    }

    @Override
    public byte[] get(String key, int chunkSize, int chunk) {
        byte[] data = (byte[])this.cacheManager.getCache("otaPackagesData").get((Object)key, byte[].class);
        if (chunkSize < 1) {
            return data;
        }
        if (data != null && data.length > 0) {
            int startIndex = chunkSize * chunk;
            int size = Math.min(data.length - startIndex, chunkSize);
            if (startIndex < data.length && size > 0) {
                byte[] result = new byte[size];
                System.arraycopy(data, startIndex, result, 0, size);
                return result;
            }
        }
        return new byte[0];
    }

    @Override
    public void put(String key, byte[] value) {
        this.cacheManager.getCache("otaPackagesData").putIfAbsent((Object)key, (Object)value);
    }

    @Override
    public void evict(String key) {
        this.cacheManager.getCache("otaPackagesData").evict((Object)key);
    }

    @ConstructorProperties(value={"cacheManager"})
    @Generated
    public CaffeineOtaPackageCache(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

