/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache.limits;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.cache.limits.TenantProfileProvider;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.exception.TenantProfileNotFoundException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.RateLimitsTrigger;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.common.msg.tools.TbRateLimits;

@Lazy
@Service
public class DefaultRateLimitService
implements RateLimitService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRateLimitService.class);
    private final TenantProfileProvider tenantProfileProvider;
    private final NotificationRuleProcessor notificationRuleProcessor;
    private final Cache<RateLimitKey, TbRateLimits> rateLimits;

    public DefaultRateLimitService(TenantProfileProvider tenantProfileProvider, @Lazy NotificationRuleProcessor notificationRuleProcessor, @Value(value="${cache.rateLimits.timeToLiveInMinutes:120}") int rateLimitsTtl, @Value(value="${cache.rateLimits.maxSize:200000}") int rateLimitsCacheMaxSize) {
        this.tenantProfileProvider = tenantProfileProvider;
        this.notificationRuleProcessor = notificationRuleProcessor;
        this.rateLimits = Caffeine.newBuilder().expireAfterAccess((long)rateLimitsTtl, TimeUnit.MINUTES).maximumSize((long)rateLimitsCacheMaxSize).build();
    }

    @Override
    public boolean checkRateLimit(LimitedApi api, TenantId tenantId) {
        return this.checkRateLimit(api, tenantId, tenantId);
    }

    @Override
    public boolean checkRateLimit(LimitedApi api, TenantId tenantId, Object level) {
        return this.checkRateLimit(api, tenantId, level, false);
    }

    @Override
    public boolean checkRateLimit(LimitedApi api, TenantId tenantId, Object level, boolean ignoreTenantNotFound) {
        if (tenantId.isSysTenantId()) {
            return true;
        }
        TenantProfile tenantProfile = this.tenantProfileProvider.get(tenantId);
        if (tenantProfile == null) {
            if (ignoreTenantNotFound) {
                return true;
            }
            throw new TenantProfileNotFoundException(tenantId);
        }
        String rateLimitConfig = tenantProfile.getProfileConfiguration().map(arg_0 -> ((LimitedApi)api).getLimitConfig(arg_0)).orElse(null);
        boolean success = this.checkRateLimit(api, level, rateLimitConfig);
        if (!success) {
            this.notificationRuleProcessor.process((NotificationRuleTrigger)RateLimitsTrigger.builder().tenantId(tenantId).api(api).limitLevel((EntityId)(level instanceof EntityId ? (EntityId)level : tenantId)).limitLevelEntityName(null).build());
        }
        return success;
    }

    @Override
    public boolean checkRateLimit(LimitedApi api, Object level, String rateLimitConfig) {
        RateLimitKey key = new RateLimitKey(api, level);
        if (StringUtils.isEmpty((String)rateLimitConfig)) {
            this.rateLimits.invalidate((Object)key);
            return true;
        }
        log.trace("[{}] Checking rate limit for {} ({})", new Object[]{level, api, rateLimitConfig});
        TbRateLimits rateLimit = this.rateLimits.asMap().compute(key, (k, limit) -> {
            if (limit == null || !limit.getConfiguration().equals(rateLimitConfig)) {
                limit = new TbRateLimits(rateLimitConfig, api.isRefillRateLimitIntervally());
                log.trace("[{}] Created new rate limit bucket for {} ({})", new Object[]{level, api, rateLimitConfig});
            }
            return limit;
        });
        boolean success = rateLimit.tryConsume();
        if (!success) {
            log.debug("[{}] Rate limit exceeded for {} ({})", new Object[]{level, api, rateLimitConfig});
        }
        return success;
    }

    @Override
    public void cleanUp(LimitedApi api, Object level) {
        RateLimitKey key = new RateLimitKey(api, level);
        this.rateLimits.invalidate((Object)key);
    }

    private static class RateLimitKey {
        private final LimitedApi api;
        private final Object level;

        @ConstructorProperties(value={"api", "level"})
        @Generated
        private RateLimitKey(LimitedApi api, Object level) {
            this.api = api;
            this.level = level;
        }

        @Generated
        public static RateLimitKey of(LimitedApi api, Object level) {
            return new RateLimitKey(api, level);
        }

        @Generated
        public LimitedApi getApi() {
            return this.api;
        }

        @Generated
        public Object getLevel() {
            return this.level;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RateLimitKey)) {
                return false;
            }
            RateLimitKey other = (RateLimitKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LimitedApi this$api = this.getApi();
            LimitedApi other$api = other.getApi();
            if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
                return false;
            }
            Object this$level = this.getLevel();
            Object other$level = other.getLevel();
            return !(this$level == null ? other$level != null : !this$level.equals(other$level));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RateLimitKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LimitedApi $api = this.getApi();
            result = result * 59 + ($api == null ? 43 : $api.hashCode());
            Object $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : $level.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultRateLimitService.RateLimitKey(api=" + String.valueOf(this.getApi()) + ", level=" + String.valueOf(this.getLevel()) + ")";
        }
    }
}

