/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import org.springframework.data.redis.serializer.SerializationException;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cache.TbRedisSerializer;

public class TbJsonRedisSerializer<K, V>
implements TbRedisSerializer<K, V> {
    private final Class<V> clazz;

    public TbJsonRedisSerializer(Class<V> clazz) {
        this.clazz = clazz;
    }

    @Override
    public byte[] serialize(V v) throws SerializationException {
        return JacksonUtil.writeValueAsBytes(v);
    }

    @Override
    public V deserialize(K key, byte[] bytes) throws SerializationException {
        return (V)JacksonUtil.fromBytes((byte[])bytes, this.clazz);
    }
}

