/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thingsboard.server.cache.CacheSpecs;
import org.thingsboard.server.cache.CacheSpecsMap;

@Configuration
@ConditionalOnProperty(prefix="cache", value={"type"}, havingValue="caffeine", matchIfMissing=true)
@EnableCaching
public class TbCaffeineCacheConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCaffeineCacheConfiguration.class);
    private final CacheSpecsMap configuration;

    public TbCaffeineCacheConfiguration(CacheSpecsMap configuration) {
        this.configuration = configuration;
    }

    @Bean
    public CacheManager cacheManager() {
        log.trace("Initializing cache: {} specs {}", (Object)Arrays.toString(RemovalCause.values()), this.configuration.getSpecs());
        SimpleCacheManager manager = new SimpleCacheManager();
        if (this.configuration.getSpecs() != null) {
            List caches = this.configuration.getSpecs().entrySet().stream().map(entry -> this.buildCache((String)entry.getKey(), (CacheSpecs)entry.getValue())).collect(Collectors.toList());
            manager.setCaches(caches);
        }
        manager.initializeCaches();
        return manager;
    }

    private CaffeineCache buildCache(String name, CacheSpecs cacheSpec) {
        Caffeine caffeineBuilder = Caffeine.newBuilder().weigher(this.collectionSafeWeigher()).maximumWeight((long)cacheSpec.getMaxSize().intValue()).ticker(this.ticker());
        if (!cacheSpec.getTimeToLiveInMinutes().equals(0)) {
            caffeineBuilder.expireAfterWrite((long)cacheSpec.getTimeToLiveInMinutes().intValue(), TimeUnit.MINUTES);
        }
        return new CaffeineCache(name, caffeineBuilder.build());
    }

    @Bean
    public Ticker ticker() {
        return Ticker.systemTicker();
    }

    private Weigher<? super Object, ? super Object> collectionSafeWeigher() {
        return (key, value) -> {
            if (value instanceof Collection) {
                return ((Collection)value).size();
            }
            return 1;
        };
    }
}

