/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.support.NullValue;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.thingsboard.server.cache.CacheSpecs;
import org.thingsboard.server.cache.CacheSpecsMap;
import org.thingsboard.server.cache.RedisTbCacheTransaction;
import org.thingsboard.server.cache.SimpleTbCacheValueWrapper;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.cache.TbCacheTransaction;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbRedisSerializer;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.FstStatsService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.Pool;

public abstract class RedisTbTransactionalCache<K extends Serializable, V extends Serializable>
implements TbTransactionalCache<K, V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisTbTransactionalCache.class);
    static final byte[] BINARY_NULL_VALUE = RedisSerializer.java().serialize(NullValue.INSTANCE);
    static final JedisPool MOCK_POOL = new JedisPool();
    @Autowired
    private FstStatsService fstStatsService;
    private final String cacheName;
    private final JedisConnectionFactory connectionFactory;
    private final RedisSerializer<String> keySerializer = StringRedisSerializer.UTF_8;
    private final TbRedisSerializer<K, V> valueSerializer;
    protected final Expiration evictExpiration;
    protected final Expiration cacheTtl;
    protected final boolean cacheEnabled;

    public RedisTbTransactionalCache(String cacheName, CacheSpecsMap cacheSpecsMap, RedisConnectionFactory connectionFactory, TBRedisCacheConfiguration configuration, TbRedisSerializer<K, V> valueSerializer) {
        this.cacheName = cacheName;
        this.connectionFactory = (JedisConnectionFactory)connectionFactory;
        this.valueSerializer = valueSerializer;
        this.evictExpiration = Expiration.from((long)configuration.getEvictTtlInMs(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.cacheTtl = Optional.ofNullable(cacheSpecsMap).map(CacheSpecsMap::getSpecs).map(specs -> (CacheSpecs)specs.get(cacheName)).map(CacheSpecs::getTimeToLiveInMinutes).filter(ttl -> !ttl.equals(0)).map(ttl -> Expiration.from((long)ttl.intValue(), (TimeUnit)TimeUnit.MINUTES)).orElseGet(Expiration::persistent);
        this.cacheEnabled = Optional.ofNullable(cacheSpecsMap).map(CacheSpecsMap::getSpecs).map(x -> (CacheSpecs)x.get(cacheName)).map(CacheSpecs::getMaxSize).map(size -> size > 0).orElse(false);
    }

    @Override
    public TbCacheValueWrapper<V> get(K key) {
        if (!this.cacheEnabled) {
            return null;
        }
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            byte[] rawValue = this.doGet(key, connection);
            if (rawValue == null || rawValue.length == 0) {
                TbCacheValueWrapper<V> tbCacheValueWrapper = null;
                return tbCacheValueWrapper;
            }
            if (Arrays.equals(rawValue, BINARY_NULL_VALUE)) {
                SimpleTbCacheValueWrapper simpleTbCacheValueWrapper = SimpleTbCacheValueWrapper.empty();
                return simpleTbCacheValueWrapper;
            }
            long startTime = System.nanoTime();
            Serializable value = (Serializable)this.valueSerializer.deserialize(key, rawValue);
            if (value != null) {
                this.fstStatsService.recordDecodeTime(value.getClass(), startTime);
                this.fstStatsService.incrementDecode(value.getClass());
            }
            SimpleTbCacheValueWrapper<Serializable> simpleTbCacheValueWrapper = SimpleTbCacheValueWrapper.wrap(value);
            return simpleTbCacheValueWrapper;
        }
    }

    protected byte[] doGet(K key, RedisConnection connection) {
        return connection.stringCommands().get(this.getRawKey(key));
    }

    @Override
    public void put(K key, V value) {
        if (!this.cacheEnabled) {
            return;
        }
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            this.put(key, value, connection);
        }
    }

    public void put(K key, V value, RedisConnection connection) {
        this.put(connection, key, value, RedisStringCommands.SetOption.UPSERT);
    }

    @Override
    public void putIfAbsent(K key, V value) {
        if (!this.cacheEnabled) {
            return;
        }
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            this.put(connection, key, value, RedisStringCommands.SetOption.SET_IF_ABSENT);
        }
    }

    @Override
    public void evict(K key) {
        if (!this.cacheEnabled) {
            return;
        }
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            connection.keyCommands().del((byte[][])new byte[][]{this.getRawKey(key)});
        }
    }

    @Override
    public void evict(Collection<K> keys) {
        if (!this.cacheEnabled) {
            return;
        }
        if (keys.isEmpty()) {
            return;
        }
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            connection.keyCommands().del((byte[][])keys.stream().map(this::getRawKey).toArray(x$0 -> new byte[x$0][]));
        }
    }

    @Override
    public void evictOrPut(K key, V value) {
        if (!this.cacheEnabled) {
            return;
        }
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            byte[] rawKey = this.getRawKey(key);
            Long records = connection.keyCommands().del((byte[][])new byte[][]{rawKey});
            if (records == null || records == 0L) {
                connection.stringCommands().set(rawKey, this.getRawValue(value), this.evictExpiration, RedisStringCommands.SetOption.UPSERT);
            }
        }
    }

    @Override
    public TbCacheTransaction<K, V> newTransactionForKey(K key) {
        byte[][] rawKey = new byte[][]{this.getRawKey(key)};
        RedisConnection connection = this.watch(rawKey);
        return new RedisTbCacheTransaction(this, connection);
    }

    @Override
    public TbCacheTransaction<K, V> newTransactionForKeys(List<K> keys) {
        RedisConnection connection = this.watch((byte[][])keys.stream().map(this::getRawKey).toArray(x$0 -> new byte[x$0][]));
        return new RedisTbCacheTransaction(this, connection);
    }

    @Override
    public <R> R getAndPutInTransaction(K key, Supplier<R> dbCall, Function<V, R> cacheValueToResult, Function<R, V> dbValueToCacheValue, boolean cacheNullValue) {
        if (!this.cacheEnabled) {
            return dbCall.get();
        }
        return TbTransactionalCache.super.getAndPutInTransaction(key, dbCall, cacheValueToResult, dbValueToCacheValue, cacheNullValue);
    }

    protected RedisConnection getConnection(byte[] rawKey) {
        if (!this.connectionFactory.isRedisClusterAware()) {
            return this.connectionFactory.getConnection();
        }
        RedisClusterConnection connection = this.connectionFactory.getClusterConnection();
        int slotNum = JedisClusterCRC16.getSlot((byte[])rawKey);
        Jedis jedis = new Jedis(((JedisClusterConnection)connection).getNativeConnection().getConnectionFromSlot(slotNum));
        JedisConnection jedisConnection = new JedisConnection(jedis, (Pool)MOCK_POOL, jedis.getDB());
        jedisConnection.setConvertPipelineAndTxResults(this.connectionFactory.getConvertPipelineAndTxResults());
        return jedisConnection;
    }

    protected RedisConnection watch(byte[][] rawKeysList) {
        RedisConnection connection = this.getConnection(rawKeysList[0]);
        try {
            connection.watch(rawKeysList);
            connection.multi();
        }
        catch (Exception e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    protected byte[] getRawKey(K key) {
        byte[] rawKey;
        String keyString = this.cacheName + key.toString();
        try {
            rawKey = this.keySerializer.serialize((Object)keyString);
        }
        catch (Exception e) {
            log.warn("Failed to serialize the cache key: {}", key, (Object)e);
            throw new RuntimeException(e);
        }
        if (rawKey == null) {
            log.warn("Failed to serialize the cache key: {}", key);
            throw new IllegalArgumentException("Failed to serialize the cache key!");
        }
        return rawKey;
    }

    protected byte[] getRawValue(V value) {
        if (value == null) {
            return BINARY_NULL_VALUE;
        }
        try {
            long startTime = System.nanoTime();
            byte[] bytes = this.valueSerializer.serialize(value);
            this.fstStatsService.recordEncodeTime(value.getClass(), startTime);
            this.fstStatsService.incrementEncode(value.getClass());
            return bytes;
        }
        catch (Exception e) {
            log.warn("Failed to serialize the cache value: {}", value, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void put(RedisConnection connection, K key, V value, RedisStringCommands.SetOption setOption) {
        if (!this.cacheEnabled) {
            return;
        }
        byte[] rawKey = this.getRawKey(key);
        this.put(connection, rawKey, value, setOption);
    }

    public void put(RedisConnection connection, byte[] rawKey, V value, RedisStringCommands.SetOption setOption) {
        byte[] rawValue = this.getRawValue(value);
        connection.stringCommands().set(rawKey, rawValue, this.cacheTtl, setOption);
    }

    protected void executeScript(RedisConnection connection, byte[] scriptSha, byte[] luaScript, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        try {
            connection.scriptingCommands().evalSha(scriptSha, returnType, numKeys, keysAndArgs);
        }
        catch (InvalidDataAccessApiUsageException ignored) {
            log.debug("Loading LUA with expected SHA [{}], connection [{}]", (Object)new String(scriptSha), connection.getNativeConnection());
            String actualSha = connection.scriptingCommands().scriptLoad(luaScript);
            if (!Arrays.equals(scriptSha, StringRedisSerializer.UTF_8.serialize(actualSha))) {
                String message = String.format("SHA for LUA script wrong! Expected [%s], but actual [%s], connection [%s]", new String(scriptSha), actualSha, connection.getNativeConnection());
                throw new IllegalStateException(message);
            }
            try {
                connection.scriptingCommands().evalSha(scriptSha, returnType, numKeys, keysAndArgs);
            }
            catch (InvalidDataAccessApiUsageException exception) {
                log.warn("Slowly executing eval instead of fast evalSha", (Throwable)exception);
                connection.scriptingCommands().eval(luaScript, returnType, numKeys, keysAndArgs);
            }
        }
    }

    @Override
    @Generated
    public String getCacheName() {
        return this.cacheName;
    }

    @Generated
    public JedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

