/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.cache.CaffeineTbTransactionalCache;
import org.thingsboard.server.cache.TbCacheTransaction;

public class CaffeineTbCacheTransaction<K extends Serializable, V extends Serializable>
implements TbCacheTransaction<K, V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CaffeineTbCacheTransaction.class);
    private final UUID id = UUID.randomUUID();
    private final CaffeineTbTransactionalCache<K, V> cache;
    private final List<K> keys;
    private boolean failed;
    private final Map<K, V> pendingPuts = new LinkedHashMap();

    @Override
    public void put(K key, V value) {
        this.pendingPuts.put(key, value);
    }

    @Override
    public boolean commit() {
        return this.cache.commit(this.id, this.pendingPuts);
    }

    @Override
    public void rollback() {
        this.cache.rollback(this.id);
    }

    @ConstructorProperties(value={"cache", "keys"})
    @Generated
    public CaffeineTbCacheTransaction(CaffeineTbTransactionalCache<K, V> cache, List<K> keys) {
        this.cache = cache;
        this.keys = keys;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public List<K> getKeys() {
        return this.keys;
    }

    @Generated
    public boolean isFailed() {
        return this.failed;
    }

    @Generated
    public void setFailed(boolean failed) {
        this.failed = failed;
    }
}

