/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache.resourceInfo;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;

public class ResourceInfoCacheKey
implements Serializable {
    private static final long serialVersionUID = 2100510964692846992L;
    private final TenantId tenantId;
    private final TbResourceId tbResourceId;

    public String toString() {
        return this.tenantId + "_" + this.tbResourceId;
    }

    public static ResourceInfoCacheKeyBuilder builder() {
        return new ResourceInfoCacheKeyBuilder();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public TbResourceId getTbResourceId() {
        return this.tbResourceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceInfoCacheKey)) {
            return false;
        }
        ResourceInfoCacheKey other = (ResourceInfoCacheKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        TbResourceId this$tbResourceId = this.getTbResourceId();
        TbResourceId other$tbResourceId = other.getTbResourceId();
        return !(this$tbResourceId == null ? other$tbResourceId != null : !this$tbResourceId.equals(other$tbResourceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceInfoCacheKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        TbResourceId $tbResourceId = this.getTbResourceId();
        result = result * 59 + ($tbResourceId == null ? 43 : $tbResourceId.hashCode());
        return result;
    }

    @ConstructorProperties(value={"tenantId", "tbResourceId"})
    public ResourceInfoCacheKey(TenantId tenantId, TbResourceId tbResourceId) {
        this.tenantId = tenantId;
        this.tbResourceId = tbResourceId;
    }

    public static class ResourceInfoCacheKeyBuilder {
        private TenantId tenantId;
        private TbResourceId tbResourceId;

        ResourceInfoCacheKeyBuilder() {
        }

        public ResourceInfoCacheKeyBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ResourceInfoCacheKeyBuilder tbResourceId(TbResourceId tbResourceId) {
            this.tbResourceId = tbResourceId;
            return this;
        }

        public ResourceInfoCacheKey build() {
            return new ResourceInfoCacheKey(this.tenantId, this.tbResourceId);
        }

        public String toString() {
            return "ResourceInfoCacheKey.ResourceInfoCacheKeyBuilder(tenantId=" + this.tenantId + ", tbResourceId=" + this.tbResourceId + ")";
        }
    }
}

