/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache.device;

import java.beans.ConstructorProperties;
import org.thingsboard.server.cache.VersionedCacheKey;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;

public class DeviceCacheKey
implements VersionedCacheKey {
    private static final long serialVersionUID = 6366389552842340207L;
    private final TenantId tenantId;
    private final DeviceId deviceId;
    private final String deviceName;

    public DeviceCacheKey(DeviceId deviceId) {
        this(null, deviceId, null);
    }

    public DeviceCacheKey(TenantId tenantId, DeviceId deviceId) {
        this(tenantId, deviceId, null);
    }

    public DeviceCacheKey(TenantId tenantId, String deviceName) {
        this(tenantId, null, deviceName);
    }

    public String toString() {
        if (this.deviceId == null) {
            return this.tenantId + "_n_" + this.deviceName;
        }
        if (this.tenantId == null) {
            return this.deviceId.toString();
        }
        return this.tenantId + "_" + this.deviceId;
    }

    @Override
    public boolean isVersioned() {
        return this.deviceId != null;
    }

    public static DeviceCacheKeyBuilder builder() {
        return new DeviceCacheKeyBuilder();
    }

    public TenantId getTenantId() {
        return this.tenantId;
    }

    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceCacheKey)) {
            return false;
        }
        DeviceCacheKey other = (DeviceCacheKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$deviceName = this.getDeviceName();
        String other$deviceName = other.getDeviceName();
        return !(this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceCacheKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $deviceName = this.getDeviceName();
        result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
        return result;
    }

    @ConstructorProperties(value={"tenantId", "deviceId", "deviceName"})
    public DeviceCacheKey(TenantId tenantId, DeviceId deviceId, String deviceName) {
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.deviceName = deviceName;
    }

    public static class DeviceCacheKeyBuilder {
        private TenantId tenantId;
        private DeviceId deviceId;
        private String deviceName;

        DeviceCacheKeyBuilder() {
        }

        public DeviceCacheKeyBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public DeviceCacheKeyBuilder deviceId(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public DeviceCacheKeyBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public DeviceCacheKey build() {
            return new DeviceCacheKey(this.tenantId, this.deviceId, this.deviceName);
        }

        public String toString() {
            return "DeviceCacheKey.DeviceCacheKeyBuilder(tenantId=" + this.tenantId + ", deviceId=" + this.deviceId + ", deviceName=" + this.deviceName + ")";
        }
    }
}

