/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.cache.VersionedCacheKey;
import org.thingsboard.server.common.data.HasVersion;

public interface VersionedTbCache<K extends VersionedCacheKey, V extends Serializable & HasVersion>
extends TbTransactionalCache<K, V> {
    @Override
    public TbCacheValueWrapper<V> get(K var1);

    default public V get(K key, Supplier<V> supplier) {
        return this.get(key, supplier, true);
    }

    default public V get(K key, Supplier<V> supplier, boolean putToCache) {
        return (V)Optional.ofNullable(this.get(key)).map(TbCacheValueWrapper::get).orElseGet(() -> {
            Serializable value = (Serializable)supplier.get();
            if (putToCache) {
                this.put(key, (V)value);
            }
            return value;
        });
    }

    @Override
    public void put(K var1, V var2);

    @Override
    public void evict(K var1);

    @Override
    public void evict(Collection<K> var1);

    public void evict(K var1, Long var2);

    default public Long getVersion(V value) {
        if (value == null) {
            return 0L;
        }
        if (((HasVersion)value).getVersion() != null) {
            return ((HasVersion)value).getVersion();
        }
        return null;
    }
}

