/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.thingsboard.server.cache.CacheSpecsMap;
import org.thingsboard.server.cache.RedisTbTransactionalCache;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.cache.TbRedisSerializer;
import org.thingsboard.server.cache.VersionedCacheKey;
import org.thingsboard.server.cache.VersionedTbCache;
import org.thingsboard.server.common.data.HasVersion;

public abstract class VersionedRedisTbCache<K extends VersionedCacheKey, V extends Serializable & HasVersion>
extends RedisTbTransactionalCache<K, V>
implements VersionedTbCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(VersionedRedisTbCache.class);
    private static final int VERSION_SIZE = 8;
    private static final int VALUE_END_OFFSET = -1;
    static final byte[] SET_VERSIONED_VALUE_LUA_SCRIPT = StringRedisSerializer.UTF_8.serialize("local key = KEYS[1]\nlocal newValue = ARGV[1]\nlocal newVersion = tonumber(ARGV[2])\nlocal expiration = tonumber(ARGV[3])\n\nlocal function setNewValue()\n    local newValueWithVersion = struct.pack(\">I8\", newVersion) .. newValue\n    redis.call('SET', key, newValueWithVersion, 'EX', expiration)\nend\n\n-- Get the current version (first 8 bytes) of the current value\nlocal currentVersionBytes = redis.call('GETRANGE', key, 0, 7)\n\nif currentVersionBytes and #currentVersionBytes == 8 then\n    local currentVersion = struct.unpack(\">I8\", currentVersionBytes)\n    if newVersion > currentVersion then\n        setNewValue()\n    end\nelse\n    -- If the current value is absent or the current version is not found, set the new value\n    setNewValue()\nend\n");
    static final byte[] SET_VERSIONED_VALUE_SHA = StringRedisSerializer.UTF_8.serialize("0453cb1814135b706b4198b09a09f43c9f67bbfe");

    public VersionedRedisTbCache(String cacheName, CacheSpecsMap cacheSpecsMap, RedisConnectionFactory connectionFactory, TBRedisCacheConfiguration configuration, TbRedisSerializer<K, V> valueSerializer) {
        super(cacheName, cacheSpecsMap, connectionFactory, configuration, valueSerializer);
    }

    @PostConstruct
    public void init() {
        try (RedisConnection connection = this.getConnection(SET_VERSIONED_VALUE_SHA);){
            log.debug("Loading LUA with expected SHA[{}], connection [{}]", (Object)new String(SET_VERSIONED_VALUE_SHA), connection.getNativeConnection());
            String sha = connection.scriptingCommands().scriptLoad(SET_VERSIONED_VALUE_LUA_SCRIPT);
            if (!Arrays.equals(SET_VERSIONED_VALUE_SHA, StringRedisSerializer.UTF_8.serialize(sha))) {
                log.error("SHA for SET_VERSIONED_VALUE_LUA_SCRIPT wrong! Expected [{}], but actual [{}], connection [{}]", new Object[]{new String(SET_VERSIONED_VALUE_SHA), sha, connection.getNativeConnection()});
            }
        }
        catch (Throwable t) {
            log.error("Error on Redis versioned cache init", t);
        }
    }

    @Override
    protected byte[] doGet(K key, RedisConnection connection) {
        if (!key.isVersioned()) {
            return super.doGet(key, connection);
        }
        byte[] rawKey = this.getRawKey(key);
        return connection.stringCommands().getRange(rawKey, 8L, -1L);
    }

    @Override
    public void put(K key, V value) {
        if (!key.isVersioned()) {
            super.put(key, value);
            return;
        }
        Long version = this.getVersion(value);
        if (version == null) {
            return;
        }
        this.doPut(key, value, version, this.cacheTtl);
    }

    @Override
    public void put(K key, V value, RedisConnection connection) {
        if (!key.isVersioned()) {
            super.put(key, value, connection);
            return;
        }
        Long version = this.getVersion(value);
        if (version == null) {
            return;
        }
        byte[] rawKey = this.getRawKey(key);
        this.doPut(rawKey, value, version, this.cacheTtl, connection);
    }

    private void doPut(K key, V value, Long version, Expiration expiration) {
        if (!this.cacheEnabled) {
            return;
        }
        log.trace("put [{}][{}][{}]", new Object[]{key, value, version});
        byte[] rawKey = this.getRawKey(key);
        try (RedisConnection connection = this.getConnection(rawKey);){
            this.doPut(rawKey, value, version, expiration, connection);
        }
    }

    private void doPut(byte[] rawKey, V value, Long version, Expiration expiration, RedisConnection connection) {
        byte[] rawValue = this.getRawValue(value);
        byte[] rawVersion = StringRedisSerializer.UTF_8.serialize(String.valueOf(version));
        byte[] rawExpiration = StringRedisSerializer.UTF_8.serialize(String.valueOf(expiration.getExpirationTimeInSeconds()));
        try {
            connection.scriptingCommands().evalSha(SET_VERSIONED_VALUE_SHA, ReturnType.VALUE, 1, (byte[][])new byte[][]{rawKey, rawValue, rawVersion, rawExpiration});
        }
        catch (InvalidDataAccessApiUsageException e) {
            log.debug("loading LUA [{}]", connection.getNativeConnection());
            String sha = connection.scriptingCommands().scriptLoad(SET_VERSIONED_VALUE_LUA_SCRIPT);
            if (!Arrays.equals(SET_VERSIONED_VALUE_SHA, StringRedisSerializer.UTF_8.serialize(sha))) {
                log.error("SHA for SET_VERSIONED_VALUE_LUA_SCRIPT wrong! Expected [{}], but actual [{}]", (Object)new String(SET_VERSIONED_VALUE_SHA), (Object)sha);
            }
            try {
                connection.scriptingCommands().evalSha(SET_VERSIONED_VALUE_SHA, ReturnType.VALUE, 1, (byte[][])new byte[][]{rawKey, rawValue, rawVersion, rawExpiration});
            }
            catch (InvalidDataAccessApiUsageException ignored) {
                log.debug("Slowly executing eval instead of fast evalsha");
                connection.scriptingCommands().eval(SET_VERSIONED_VALUE_LUA_SCRIPT, ReturnType.VALUE, 1, (byte[][])new byte[][]{rawKey, rawValue, rawVersion, rawExpiration});
            }
        }
    }

    @Override
    public void evict(K key, Long version) {
        log.trace("evict [{}][{}]", key, (Object)version);
        if (version != null) {
            this.doPut(key, null, version, this.evictExpiration);
        }
    }

    @Override
    public void putIfAbsent(K key, V value) {
        throw new NotImplementedException("putIfAbsent is not supported by versioned cache");
    }

    @Override
    public void evictOrPut(K key, V value) {
        throw new NotImplementedException("evictOrPut is not supported by versioned cache");
    }
}

