/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.io.Serializable;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.thingsboard.server.cache.CaffeineTbTransactionalCache;
import org.thingsboard.server.cache.SimpleTbCacheValueWrapper;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.VersionedCacheKey;
import org.thingsboard.server.cache.VersionedTbCache;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.util.TbPair;

public abstract class VersionedCaffeineTbCache<K extends VersionedCacheKey, V extends Serializable & HasVersion>
extends CaffeineTbTransactionalCache<K, V>
implements VersionedTbCache<K, V> {
    public VersionedCaffeineTbCache(CacheManager cacheManager, String cacheName) {
        super(cacheManager, cacheName);
    }

    @Override
    public TbCacheValueWrapper<V> get(K key) {
        TbPair<Long, V> versionValuePair = this.doGet(key);
        if (versionValuePair != null) {
            return SimpleTbCacheValueWrapper.wrap((Serializable)versionValuePair.getSecond());
        }
        return null;
    }

    @Override
    public void put(K key, V value) {
        Long version = this.getVersion(value);
        if (version == null) {
            return;
        }
        this.doPut(key, value, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPut(K key, V value, Long version) {
        this.lock.lock();
        try {
            TbPair<Long, V> versionValuePair = this.doGet(key);
            if (versionValuePair == null || version > (Long)versionValuePair.getFirst()) {
                this.failAllTransactionsByKey(key);
                this.cache.put(key, this.wrapValue(value, version));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private TbPair<Long, V> doGet(K key) {
        Cache.ValueWrapper source = this.cache.get(key);
        return source == null ? null : (TbPair)source.get();
    }

    @Override
    public void evict(K key) {
        this.lock.lock();
        try {
            this.failAllTransactionsByKey(key);
            this.cache.evict(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void evict(K key, Long version) {
        if (version == null) {
            return;
        }
        this.doPut(key, null, version);
    }

    @Override
    void doPutIfAbsent(K key, V value) {
        this.cache.putIfAbsent(key, this.wrapValue(value, this.getVersion(value)));
    }

    private TbPair<Long, V> wrapValue(V value, Long version) {
        return TbPair.of((Object)version, value);
    }
}

