/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.cache.TbCaffeineCacheConfiguration;

@Configuration
@ConditionalOnMissingBean(value={TbCaffeineCacheConfiguration.class})
@ConditionalOnProperty(prefix="redis.connection", value={"type"}, havingValue="sentinel")
public class TBRedisSentinelConfiguration
extends TBRedisCacheConfiguration {
    @Value(value="${redis.sentinel.master:}")
    private String master;
    @Value(value="${redis.sentinel.sentinels:}")
    private String sentinels;
    @Value(value="${redis.sentinel.password:}")
    private String sentinelPassword;
    @Value(value="${redis.sentinel.useDefaultPoolConfig:true}")
    private boolean useDefaultPoolConfig;
    @Value(value="${redis.db:}")
    private Integer database;
    @Value(value="${redis.ssl.enabled:false}")
    private boolean useSsl;
    @Value(value="${redis.password:}")
    private String password;

    @Override
    public JedisConnectionFactory loadFactory() {
        RedisSentinelConfiguration redisSentinelConfiguration = new RedisSentinelConfiguration();
        redisSentinelConfiguration.setMaster(this.master);
        redisSentinelConfiguration.setSentinels(this.getNodes(this.sentinels));
        redisSentinelConfiguration.setSentinelPassword(this.sentinelPassword);
        redisSentinelConfiguration.setPassword(this.password);
        redisSentinelConfiguration.setDatabase(this.database.intValue());
        return new JedisConnectionFactory(redisSentinelConfiguration, this.buildClientConfig());
    }

    private JedisClientConfiguration buildClientConfig() {
        JedisClientConfiguration.JedisClientConfigurationBuilder jedisClientConfigurationBuilder = JedisClientConfiguration.builder();
        if (!this.useDefaultPoolConfig) {
            jedisClientConfigurationBuilder.usePooling().poolConfig((GenericObjectPoolConfig)this.buildPoolConfig());
        }
        if (this.useSsl) {
            jedisClientConfigurationBuilder.useSsl().sslSocketFactory(this.createSslSocketFactory());
        }
        return jedisClientConfigurationBuilder.build();
    }
}

