/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.cache.TbCaffeineCacheConfiguration;

@Configuration
@ConditionalOnMissingBean(value={TbCaffeineCacheConfiguration.class})
@ConditionalOnProperty(prefix="redis.connection", value={"type"}, havingValue="cluster")
public class TBRedisClusterConfiguration
extends TBRedisCacheConfiguration {
    @Value(value="${redis.cluster.nodes:}")
    private String clusterNodes;
    @Value(value="${redis.cluster.max-redirects:12}")
    private Integer maxRedirects;
    @Value(value="${redis.cluster.useDefaultPoolConfig:true}")
    private boolean useDefaultPoolConfig;
    @Value(value="${redis.password:}")
    private String password;
    @Value(value="${redis.ssl.enabled:false}")
    private boolean useSsl;

    @Override
    public JedisConnectionFactory loadFactory() {
        RedisClusterConfiguration clusterConfiguration = new RedisClusterConfiguration();
        clusterConfiguration.setClusterNodes(this.getNodes(this.clusterNodes));
        clusterConfiguration.setMaxRedirects(this.maxRedirects.intValue());
        clusterConfiguration.setPassword(this.password);
        return new JedisConnectionFactory(clusterConfiguration, this.buildClientConfig());
    }

    private JedisClientConfiguration buildClientConfig() {
        JedisClientConfiguration.JedisClientConfigurationBuilder jedisClientConfigurationBuilder = JedisClientConfiguration.builder();
        if (!this.useDefaultPoolConfig) {
            jedisClientConfigurationBuilder.usePooling().poolConfig((GenericObjectPoolConfig)this.buildPoolConfig());
        }
        if (this.useSsl) {
            jedisClientConfigurationBuilder.useSsl().sslSocketFactory(this.createSslSocketFactory());
        }
        return jedisClientConfigurationBuilder.build();
    }
}

