/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.thingsboard.server.cache.CaffeineTbCacheTransaction;
import org.thingsboard.server.cache.SimpleTbCacheValueWrapper;
import org.thingsboard.server.cache.TbCacheTransaction;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbTransactionalCache;

public abstract class CaffeineTbTransactionalCache<K extends Serializable, V extends Serializable>
implements TbTransactionalCache<K, V> {
    protected final String cacheName;
    protected final Cache cache;
    protected final Lock lock = new ReentrantLock();
    private final Map<K, Set<UUID>> objectTransactions = new HashMap<K, Set<UUID>>();
    private final Map<UUID, CaffeineTbCacheTransaction<K, V>> transactions = new HashMap<UUID, CaffeineTbCacheTransaction<K, V>>();

    public CaffeineTbTransactionalCache(CacheManager cacheManager, String cacheName) {
        this.cacheName = cacheName;
        this.cache = Optional.ofNullable(cacheManager.getCache(cacheName)).orElseThrow(() -> new IllegalArgumentException("Cache '" + cacheName + "' is not configured"));
    }

    @Override
    public TbCacheValueWrapper<V> get(K key) {
        return SimpleTbCacheValueWrapper.wrap(this.cache.get(key));
    }

    @Override
    public void put(K key, V value) {
        this.lock.lock();
        try {
            this.failAllTransactionsByKey(key);
            this.cache.put(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void putIfAbsent(K key, V value) {
        this.lock.lock();
        try {
            this.failAllTransactionsByKey(key);
            this.doPutIfAbsent(key, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void evict(K key) {
        this.lock.lock();
        try {
            this.failAllTransactionsByKey(key);
            this.doEvict(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void evict(Collection<K> keys) {
        this.lock.lock();
        try {
            keys.forEach(key -> {
                this.failAllTransactionsByKey(key);
                this.doEvict(key);
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void evictOrPut(K key, V value) {
        this.evict(key);
    }

    @Override
    public TbCacheTransaction<K, V> newTransactionForKey(K key) {
        return this.newTransaction(Collections.singletonList(key));
    }

    @Override
    public TbCacheTransaction<K, V> newTransactionForKeys(List<K> keys) {
        return this.newTransaction(keys);
    }

    void doPutIfAbsent(K key, V value) {
        this.cache.putIfAbsent(key, value);
    }

    void doEvict(K key) {
        this.cache.evict(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TbCacheTransaction<K, V> newTransaction(List<K> keys) {
        this.lock.lock();
        try {
            CaffeineTbCacheTransaction transaction = new CaffeineTbCacheTransaction(this, keys);
            UUID transactionId = transaction.getId();
            for (Serializable key : keys) {
                this.objectTransactions.computeIfAbsent(key, k -> new HashSet()).add(transactionId);
            }
            this.transactions.put(transactionId, transaction);
            CaffeineTbCacheTransaction caffeineTbCacheTransaction = transaction;
            return caffeineTbCacheTransaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(UUID trId, Map<K, V> pendingPuts) {
        this.lock.lock();
        try {
            boolean success;
            CaffeineTbCacheTransaction<K, V> tr = this.transactions.get(trId);
            boolean bl = success = !tr.isFailed();
            if (success) {
                for (Serializable key : tr.getKeys()) {
                    Set<UUID> otherTransactions = this.objectTransactions.get(key);
                    if (otherTransactions == null) continue;
                    for (UUID otherTrId : otherTransactions) {
                        if (trId != null && trId.equals(otherTrId)) continue;
                        this.transactions.get(otherTrId).setFailed(true);
                    }
                }
                pendingPuts.forEach(this::doPutIfAbsent);
            }
            this.removeTransaction(trId);
            boolean bl2 = success;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    void rollback(UUID id) {
        this.lock.lock();
        try {
            this.removeTransaction(id);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeTransaction(UUID id) {
        CaffeineTbCacheTransaction<K, V> transaction = this.transactions.remove(id);
        if (transaction != null) {
            for (Serializable key : transaction.getKeys()) {
                Set<UUID> transactions = this.objectTransactions.get(key);
                if (transactions == null) continue;
                transactions.remove(id);
                if (!transactions.isEmpty()) continue;
                this.objectTransactions.remove(key);
            }
        }
    }

    protected void failAllTransactionsByKey(K key) {
        Set<UUID> transactionsIds = this.objectTransactions.get(key);
        if (transactionsIds != null) {
            for (UUID otherTrId : transactionsIds) {
                this.transactions.get(otherTrId).setFailed(true);
            }
        }
    }

    @ConstructorProperties(value={"cacheName", "cache"})
    public CaffeineTbTransactionalCache(String cacheName, Cache cache) {
        this.cacheName = cacheName;
        this.cache = cache;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }
}

