/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.thingsboard.server.cache.CacheSpecs;

@Configuration
@ConfigurationProperties(prefix="cache")
public class CacheSpecsMap {
    @Value(value="${security.jwt.refreshTokenExpTime:604800}")
    private int refreshTokenExpTime;
    private Map<String, CacheSpecs> specs;

    @PostConstruct
    public void replaceTheJWTTokenRefreshExpTime() {
        CacheSpecs cacheSpecs;
        if (this.specs != null && (cacheSpecs = this.specs.get("userSessionsInvalidation")) != null) {
            cacheSpecs.setTimeToLiveInMinutes(this.refreshTokenExpTime / 60 + 1);
        }
    }

    public int getRefreshTokenExpTime() {
        return this.refreshTokenExpTime;
    }

    public void setRefreshTokenExpTime(int refreshTokenExpTime) {
        this.refreshTokenExpTime = refreshTokenExpTime;
    }

    public void setSpecs(Map<String, CacheSpecs> specs) {
        this.specs = specs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheSpecsMap)) {
            return false;
        }
        CacheSpecsMap other = (CacheSpecsMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRefreshTokenExpTime() != other.getRefreshTokenExpTime()) {
            return false;
        }
        Map<String, CacheSpecs> this$specs = this.getSpecs();
        Map<String, CacheSpecs> other$specs = other.getSpecs();
        return !(this$specs == null ? other$specs != null : !((Object)this$specs).equals(other$specs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheSpecsMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRefreshTokenExpTime();
        Map<String, CacheSpecs> $specs = this.getSpecs();
        result = result * 59 + ($specs == null ? 43 : ((Object)$specs).hashCode());
        return result;
    }

    public String toString() {
        return "CacheSpecsMap(refreshTokenExpTime=" + this.getRefreshTokenExpTime() + ", specs=" + this.getSpecs() + ")";
    }

    public Map<String, CacheSpecs> getSpecs() {
        return this.specs;
    }
}

