/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.cache.TbCaffeineCacheConfiguration;

@Configuration
@ConditionalOnMissingBean(value={TbCaffeineCacheConfiguration.class})
@ConditionalOnProperty(prefix="redis.connection", value={"type"}, havingValue="standalone")
public class TBRedisStandaloneConfiguration
extends TBRedisCacheConfiguration {
    @Value(value="${redis.standalone.host:localhost}")
    private String host;
    @Value(value="${redis.standalone.port:6379}")
    private Integer port;
    @Value(value="${redis.standalone.clientName:standalone}")
    private String clientName;
    @Value(value="${redis.standalone.connectTimeout:30000}")
    private Long connectTimeout;
    @Value(value="${redis.standalone.readTimeout:60000}")
    private Long readTimeout;
    @Value(value="${redis.standalone.useDefaultClientConfig:true}")
    private boolean useDefaultClientConfig;
    @Value(value="${redis.standalone.usePoolConfig:false}")
    private boolean usePoolConfig;
    @Value(value="${redis.db:0}")
    private Integer db;
    @Value(value="${redis.password:}")
    private String password;

    @Override
    public JedisConnectionFactory loadFactory() {
        RedisStandaloneConfiguration standaloneConfiguration = new RedisStandaloneConfiguration();
        standaloneConfiguration.setHostName(this.host);
        standaloneConfiguration.setPort(this.port.intValue());
        standaloneConfiguration.setDatabase(this.db.intValue());
        standaloneConfiguration.setPassword(this.password);
        if (this.useDefaultClientConfig) {
            return new JedisConnectionFactory(standaloneConfiguration);
        }
        return new JedisConnectionFactory(standaloneConfiguration, this.buildClientConfig());
    }

    private JedisClientConfiguration buildClientConfig() {
        if (this.usePoolConfig) {
            return JedisClientConfiguration.builder().clientName(this.clientName).connectTimeout(Duration.ofMillis(this.connectTimeout)).readTimeout(Duration.ofMillis(this.readTimeout)).usePooling().poolConfig((GenericObjectPoolConfig)this.buildPoolConfig()).build();
        }
        return JedisClientConfiguration.builder().clientName(this.clientName).connectTimeout(Duration.ofMillis(this.connectTimeout)).readTimeout(Duration.ofMillis(this.readTimeout)).build();
    }
}

