/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.support.NullValue;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.thingsboard.server.cache.CacheSpecs;
import org.thingsboard.server.cache.CacheSpecsMap;
import org.thingsboard.server.cache.RedisTbCacheTransaction;
import org.thingsboard.server.cache.SimpleTbCacheValueWrapper;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.cache.TbCacheTransaction;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbRedisSerializer;
import org.thingsboard.server.cache.TbTransactionalCache;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.Pool;

public abstract class RedisTbTransactionalCache<K extends Serializable, V extends Serializable>
implements TbTransactionalCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RedisTbTransactionalCache.class);
    private static final byte[] BINARY_NULL_VALUE = RedisSerializer.java().serialize(NullValue.INSTANCE);
    static final JedisPool MOCK_POOL = new JedisPool();
    private final String cacheName;
    private final JedisConnectionFactory connectionFactory;
    private final RedisSerializer<String> keySerializer = StringRedisSerializer.UTF_8;
    private final TbRedisSerializer<K, V> valueSerializer;
    private final Expiration evictExpiration;
    private final Expiration cacheTtl;

    public RedisTbTransactionalCache(String cacheName, CacheSpecsMap cacheSpecsMap, RedisConnectionFactory connectionFactory, TBRedisCacheConfiguration configuration, TbRedisSerializer<K, V> valueSerializer) {
        this.cacheName = cacheName;
        this.connectionFactory = (JedisConnectionFactory)connectionFactory;
        this.valueSerializer = valueSerializer;
        this.evictExpiration = Expiration.from((long)configuration.getEvictTtlInMs(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.cacheTtl = Optional.ofNullable(cacheSpecsMap).map(CacheSpecsMap::getSpecs).map(x -> (CacheSpecs)x.get(cacheName)).map(CacheSpecs::getTimeToLiveInMinutes).map(t -> Expiration.from((long)t.intValue(), (TimeUnit)TimeUnit.MINUTES)).orElseGet(Expiration::persistent);
    }

    @Override
    public TbCacheValueWrapper<V> get(K key) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            byte[] rawKey = this.getRawKey(key);
            byte[] rawValue = connection.get(rawKey);
            if (rawValue == null) {
                TbCacheValueWrapper<V> tbCacheValueWrapper = null;
                return tbCacheValueWrapper;
            }
            if (Arrays.equals(rawValue, BINARY_NULL_VALUE)) {
                SimpleTbCacheValueWrapper simpleTbCacheValueWrapper = SimpleTbCacheValueWrapper.empty();
                return simpleTbCacheValueWrapper;
            }
            Serializable value = (Serializable)this.valueSerializer.deserialize(key, rawValue);
            SimpleTbCacheValueWrapper<Serializable> simpleTbCacheValueWrapper = SimpleTbCacheValueWrapper.wrap(value);
            return simpleTbCacheValueWrapper;
        }
    }

    @Override
    public void put(K key, V value) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            this.put(connection, key, value, RedisStringCommands.SetOption.UPSERT);
        }
    }

    @Override
    public void putIfAbsent(K key, V value) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            this.put(connection, key, value, RedisStringCommands.SetOption.SET_IF_ABSENT);
        }
    }

    @Override
    public void evict(K key) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            connection.del((byte[][])new byte[][]{this.getRawKey(key)});
        }
    }

    @Override
    public void evict(Collection<K> keys) {
        if (keys.isEmpty()) {
            return;
        }
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            connection.del((byte[][])keys.stream().map(this::getRawKey).toArray(x$0 -> new byte[x$0][]));
        }
    }

    @Override
    public void evictOrPut(K key, V value) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            byte[] rawKey = this.getRawKey(key);
            Long records = connection.del((byte[][])new byte[][]{rawKey});
            if (records == null || records == 0L) {
                connection.set(rawKey, this.getRawValue(value), this.evictExpiration, RedisStringCommands.SetOption.UPSERT);
            }
        }
    }

    @Override
    public TbCacheTransaction<K, V> newTransactionForKey(K key) {
        byte[][] rawKey = new byte[][]{this.getRawKey(key)};
        RedisConnection connection = this.watch(rawKey);
        return new RedisTbCacheTransaction(this, connection);
    }

    @Override
    public TbCacheTransaction<K, V> newTransactionForKeys(List<K> keys) {
        RedisConnection connection = this.watch((byte[][])keys.stream().map(this::getRawKey).toArray(x$0 -> new byte[x$0][]));
        return new RedisTbCacheTransaction(this, connection);
    }

    private RedisConnection getConnection(byte[] rawKey) {
        if (!this.connectionFactory.isRedisClusterAware()) {
            return this.connectionFactory.getConnection();
        }
        RedisClusterConnection connection = this.connectionFactory.getClusterConnection();
        int slotNum = JedisClusterCRC16.getSlot((byte[])rawKey);
        Jedis jedis = ((JedisClusterConnection)connection).getNativeConnection().getConnectionFromSlot(slotNum);
        JedisConnection jedisConnection = new JedisConnection(jedis, (Pool)MOCK_POOL, jedis.getDB());
        jedisConnection.setConvertPipelineAndTxResults(this.connectionFactory.getConvertPipelineAndTxResults());
        return jedisConnection;
    }

    private RedisConnection watch(byte[][] rawKeysList) {
        RedisConnection connection = this.getConnection(rawKeysList[0]);
        try {
            connection.watch(rawKeysList);
            connection.multi();
        }
        catch (Exception e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    private byte[] getRawKey(K key) {
        byte[] rawKey;
        String keyString = this.cacheName + key.toString();
        try {
            rawKey = this.keySerializer.serialize((Object)keyString);
        }
        catch (Exception e) {
            log.warn("Failed to serialize the cache key: {}", key, (Object)e);
            throw new RuntimeException(e);
        }
        if (rawKey == null) {
            log.warn("Failed to serialize the cache key: {}", key);
            throw new IllegalArgumentException("Failed to serialize the cache key!");
        }
        return rawKey;
    }

    private byte[] getRawValue(V value) {
        if (value == null) {
            return BINARY_NULL_VALUE;
        }
        try {
            return this.valueSerializer.serialize(value);
        }
        catch (Exception e) {
            log.warn("Failed to serialize the cache value: {}", value, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void put(RedisConnection connection, K key, V value, RedisStringCommands.SetOption setOption) {
        byte[] rawKey = this.getRawKey(key);
        byte[] rawValue = this.getRawValue(value);
        connection.set(rawKey, rawValue, this.cacheTtl, setOption);
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }
}

