/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.Assert;
import org.thingsboard.server.common.data.id.EntityId;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConditionalOnProperty(prefix="cache", value={"type"}, havingValue="redis")
@EnableCaching
public abstract class TBRedisCacheConfiguration {
    @Value(value="${redis.evictTtlInMs:60000}")
    private int evictTtlInMs;
    @Value(value="${redis.pool_config.maxTotal:128}")
    private int maxTotal;
    @Value(value="${redis.pool_config.maxIdle:128}")
    private int maxIdle;
    @Value(value="${redis.pool_config.minIdle:16}")
    private int minIdle;
    @Value(value="${redis.pool_config.testOnBorrow:true}")
    private boolean testOnBorrow;
    @Value(value="${redis.pool_config.testOnReturn:true}")
    private boolean testOnReturn;
    @Value(value="${redis.pool_config.testWhileIdle:true}")
    private boolean testWhileIdle;
    @Value(value="${redis.pool_config.minEvictableMs:60000}")
    private long minEvictableMs;
    @Value(value="${redis.pool_config.evictionRunsMs:30000}")
    private long evictionRunsMs;
    @Value(value="${redis.pool_config.maxWaitMills:60000}")
    private long maxWaitMills;
    @Value(value="${redis.pool_config.numberTestsPerEvictionRun:3}")
    private int numberTestsPerEvictionRun;
    @Value(value="${redis.pool_config.blockWhenExhausted:true}")
    private boolean blockWhenExhausted;

    @Bean
    public RedisConnectionFactory redisConnectionFactory() {
        return this.loadFactory();
    }

    protected abstract JedisConnectionFactory loadFactory();

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory cf) {
        DefaultFormattingConversionService redisConversionService = new DefaultFormattingConversionService();
        RedisCacheConfiguration.registerDefaultConverters((ConverterRegistry)redisConversionService);
        TBRedisCacheConfiguration.registerDefaultConverters((ConverterRegistry)redisConversionService);
        RedisCacheConfiguration configuration = RedisCacheConfiguration.defaultCacheConfig().withConversionService((ConversionService)redisConversionService);
        return RedisCacheManager.builder((RedisConnectionFactory)cf).cacheDefaults(configuration).transactionAware().build();
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(this.redisConnectionFactory());
        return template;
    }

    private static void registerDefaultConverters(ConverterRegistry registry) {
        Assert.notNull((Object)registry, (String)"ConverterRegistry must not be null!");
        registry.addConverter(EntityId.class, String.class, Object::toString);
    }

    protected JedisPoolConfig buildPoolConfig() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(this.maxTotal);
        poolConfig.setMaxIdle(this.maxIdle);
        poolConfig.setMinIdle(this.minIdle);
        poolConfig.setTestOnBorrow(this.testOnBorrow);
        poolConfig.setTestOnReturn(this.testOnReturn);
        poolConfig.setTestWhileIdle(this.testWhileIdle);
        poolConfig.setSoftMinEvictableIdleTime(Duration.ofMillis(this.minEvictableMs));
        poolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(this.evictionRunsMs));
        poolConfig.setMaxWaitMillis(this.maxWaitMills);
        poolConfig.setNumTestsPerEvictionRun(this.numberTestsPerEvictionRun);
        poolConfig.setBlockWhenExhausted(this.blockWhenExhausted);
        return poolConfig;
    }

    public int getEvictTtlInMs() {
        return this.evictTtlInMs;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public long getMinEvictableMs() {
        return this.minEvictableMs;
    }

    public long getEvictionRunsMs() {
        return this.evictionRunsMs;
    }

    public long getMaxWaitMills() {
        return this.maxWaitMills;
    }

    public int getNumberTestsPerEvictionRun() {
        return this.numberTestsPerEvictionRun;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public void setEvictTtlInMs(int evictTtlInMs) {
        this.evictTtlInMs = evictTtlInMs;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public void setMinEvictableMs(long minEvictableMs) {
        this.minEvictableMs = minEvictableMs;
    }

    public void setEvictionRunsMs(long evictionRunsMs) {
        this.evictionRunsMs = evictionRunsMs;
    }

    public void setMaxWaitMills(long maxWaitMills) {
        this.maxWaitMills = maxWaitMills;
    }

    public void setNumberTestsPerEvictionRun(int numberTestsPerEvictionRun) {
        this.numberTestsPerEvictionRun = numberTestsPerEvictionRun;
    }

    public void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TBRedisCacheConfiguration)) {
            return false;
        }
        TBRedisCacheConfiguration other = (TBRedisCacheConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEvictTtlInMs() != other.getEvictTtlInMs()) {
            return false;
        }
        if (this.getMaxTotal() != other.getMaxTotal()) {
            return false;
        }
        if (this.getMaxIdle() != other.getMaxIdle()) {
            return false;
        }
        if (this.getMinIdle() != other.getMinIdle()) {
            return false;
        }
        if (this.isTestOnBorrow() != other.isTestOnBorrow()) {
            return false;
        }
        if (this.isTestOnReturn() != other.isTestOnReturn()) {
            return false;
        }
        if (this.isTestWhileIdle() != other.isTestWhileIdle()) {
            return false;
        }
        if (this.getMinEvictableMs() != other.getMinEvictableMs()) {
            return false;
        }
        if (this.getEvictionRunsMs() != other.getEvictionRunsMs()) {
            return false;
        }
        if (this.getMaxWaitMills() != other.getMaxWaitMills()) {
            return false;
        }
        if (this.getNumberTestsPerEvictionRun() != other.getNumberTestsPerEvictionRun()) {
            return false;
        }
        return this.isBlockWhenExhausted() == other.isBlockWhenExhausted();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TBRedisCacheConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEvictTtlInMs();
        result = result * 59 + this.getMaxTotal();
        result = result * 59 + this.getMaxIdle();
        result = result * 59 + this.getMinIdle();
        result = result * 59 + (this.isTestOnBorrow() ? 79 : 97);
        result = result * 59 + (this.isTestOnReturn() ? 79 : 97);
        result = result * 59 + (this.isTestWhileIdle() ? 79 : 97);
        long $minEvictableMs = this.getMinEvictableMs();
        result = result * 59 + (int)($minEvictableMs >>> 32 ^ $minEvictableMs);
        long $evictionRunsMs = this.getEvictionRunsMs();
        result = result * 59 + (int)($evictionRunsMs >>> 32 ^ $evictionRunsMs);
        long $maxWaitMills = this.getMaxWaitMills();
        result = result * 59 + (int)($maxWaitMills >>> 32 ^ $maxWaitMills);
        result = result * 59 + this.getNumberTestsPerEvictionRun();
        result = result * 59 + (this.isBlockWhenExhausted() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TBRedisCacheConfiguration(evictTtlInMs=" + this.getEvictTtlInMs() + ", maxTotal=" + this.getMaxTotal() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", testOnBorrow=" + this.isTestOnBorrow() + ", testOnReturn=" + this.isTestOnReturn() + ", testWhileIdle=" + this.isTestWhileIdle() + ", minEvictableMs=" + this.getMinEvictableMs() + ", evictionRunsMs=" + this.getEvictionRunsMs() + ", maxWaitMills=" + this.getMaxWaitMills() + ", numberTestsPerEvictionRun=" + this.getNumberTestsPerEvictionRun() + ", blockWhenExhausted=" + this.isBlockWhenExhausted() + ")";
    }
}

