/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.thingsboard.server.cache.RedisTbTransactionalCache;
import org.thingsboard.server.cache.TbCacheTransaction;

public class RedisTbCacheTransaction<K extends Serializable, V extends Serializable>
implements TbCacheTransaction<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RedisTbCacheTransaction.class);
    private final RedisTbTransactionalCache<K, V> cache;
    private final RedisConnection connection;

    @Override
    public void putIfAbsent(K key, V value) {
        this.cache.put(this.connection, key, value, RedisStringCommands.SetOption.UPSERT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit() {
        try {
            boolean result;
            List execResult = this.connection.exec();
            boolean bl = result = execResult != null && execResult.stream().anyMatch(Objects::nonNull);
            return bl;
        }
        finally {
            this.connection.close();
        }
    }

    @Override
    public void rollback() {
        try {
            this.connection.discard();
        }
        finally {
            this.connection.close();
        }
    }

    @ConstructorProperties(value={"cache", "connection"})
    public RedisTbCacheTransaction(RedisTbTransactionalCache<K, V> cache, RedisConnection connection) {
        this.cache = cache;
        this.connection = connection;
    }
}

