/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.thingsboard.server.cache.TbCacheTransaction;
import org.thingsboard.server.cache.TbCacheValueWrapper;

public interface TbTransactionalCache<K extends Serializable, V extends Serializable> {
    public String getCacheName();

    public TbCacheValueWrapper<V> get(K var1);

    public void put(K var1, V var2);

    public void putIfAbsent(K var1, V var2);

    public void evict(K var1);

    public void evict(Collection<K> var1);

    public void evictOrPut(K var1, V var2);

    public TbCacheTransaction<K, V> newTransactionForKey(K var1);

    public TbCacheTransaction<K, V> newTransactionForKeys(List<K> var1);

    default public V getAndPutInTransaction(K key, Supplier<V> dbCall, boolean cacheNullValue) {
        TbCacheValueWrapper<V> cacheValueWrapper = this.get(key);
        if (cacheValueWrapper != null) {
            return (V)((Serializable)cacheValueWrapper.get());
        }
        TbCacheTransaction<K, Serializable> cacheTransaction = this.newTransactionForKey(key);
        try {
            Serializable dbValue = (Serializable)dbCall.get();
            if (dbValue != null || cacheNullValue) {
                cacheTransaction.putIfAbsent(key, dbValue);
                cacheTransaction.commit();
                return (V)dbValue;
            }
            cacheTransaction.rollback();
            return null;
        }
        catch (Throwable e) {
            cacheTransaction.rollback();
            throw e;
        }
    }

    default public <R> R getAndPutInTransaction(K key, Supplier<R> dbCall, Function<V, R> cacheValueToResult, Function<R, V> dbValueToCacheValue, boolean cacheNullValue) {
        TbCacheValueWrapper<V> cacheValueWrapper = this.get(key);
        if (cacheValueWrapper != null) {
            Serializable cacheValue = (Serializable)cacheValueWrapper.get();
            return cacheValue == null ? null : (R)cacheValueToResult.apply(cacheValue);
        }
        TbCacheTransaction<K, Serializable> cacheTransaction = this.newTransactionForKey(key);
        try {
            R dbValue = dbCall.get();
            if (dbValue != null || cacheNullValue) {
                cacheTransaction.putIfAbsent(key, (Serializable)dbValueToCacheValue.apply(dbValue));
                cacheTransaction.commit();
                return dbValue;
            }
            cacheTransaction.rollback();
            return null;
        }
        catch (Throwable e) {
            cacheTransaction.rollback();
            throw e;
        }
    }
}

