/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.thingsboard.server.cache.TBRedisCacheConfiguration;
import org.thingsboard.server.cache.TbCaffeineCacheConfiguration;
import org.thingsboard.server.common.data.StringUtils;

@Configuration
@ConditionalOnMissingBean(value={TbCaffeineCacheConfiguration.class})
@ConditionalOnProperty(prefix="redis.connection", value={"type"}, havingValue="cluster")
public class TBRedisClusterConfiguration
extends TBRedisCacheConfiguration {
    private static final String COMMA = ",";
    private static final String COLON = ":";
    @Value(value="${redis.cluster.nodes:}")
    private String clusterNodes;
    @Value(value="${redis.cluster.max-redirects:12}")
    private Integer maxRedirects;
    @Value(value="${redis.cluster.useDefaultPoolConfig:true}")
    private boolean useDefaultPoolConfig;
    @Value(value="${redis.password:}")
    private String password;

    @Override
    public JedisConnectionFactory loadFactory() {
        RedisClusterConfiguration clusterConfiguration = new RedisClusterConfiguration();
        clusterConfiguration.setClusterNodes(this.getNodes(this.clusterNodes));
        clusterConfiguration.setMaxRedirects(this.maxRedirects.intValue());
        clusterConfiguration.setPassword(this.password);
        if (this.useDefaultPoolConfig) {
            return new JedisConnectionFactory(clusterConfiguration);
        }
        return new JedisConnectionFactory(clusterConfiguration, this.buildPoolConfig());
    }

    private List<RedisNode> getNodes(String nodes) {
        List<RedisNode> result;
        if (StringUtils.isBlank((String)nodes)) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            for (String hostPort : nodes.split(COMMA)) {
                String host = hostPort.split(COLON)[0];
                Integer port = Integer.valueOf(hostPort.split(COLON)[1]);
                result.add(new RedisNode(host, port.intValue()));
            }
        }
        return result;
    }
}

