/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.RecoveryAware;
import org.thingsboard.server.actors.Dispatcher;
import org.thingsboard.server.actors.InitFailureStrategy;
import org.thingsboard.server.actors.ProcessFailureStrategy;
import org.thingsboard.server.actors.TbActor;
import org.thingsboard.server.actors.TbActorCreator;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbActorSystem;
import org.thingsboard.server.actors.TbActorSystemSettings;
import org.thingsboard.server.actors.TbRuleNodeUpdateException;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbActorStopReason;

public final class TbActorMailbox
implements TbActorCtx {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbActorMailbox.class);
    private static final boolean HIGH_PRIORITY = true;
    private static final boolean NORMAL_PRIORITY = false;
    private static final boolean FREE = false;
    private static final boolean BUSY = true;
    private static final boolean NOT_READY = false;
    private static final boolean READY = true;
    private final TbActorSystem system;
    private final TbActorSystemSettings settings;
    private final TbActorId selfId;
    private final TbActorRef parentRef;
    private final TbActor actor;
    private final Dispatcher dispatcher;
    private final ConcurrentLinkedQueue<TbActorMsg> highPriorityMsgs = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<TbActorMsg> normalPriorityMsgs = new ConcurrentLinkedQueue();
    private final AtomicBoolean busy = new AtomicBoolean(false);
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private final AtomicBoolean destroyInProgress = new AtomicBoolean();
    private volatile TbActorStopReason stopReason;

    public void initActor() {
        this.dispatcher.getExecutor().execute(() -> this.tryInit(1));
    }

    private void tryInit(int attempt) {
        try {
            log.debug("[{}] Trying to init actor, attempt: {}", (Object)this.selfId, (Object)attempt);
            if (!this.destroyInProgress.get()) {
                this.actor.init(this);
                if (!this.destroyInProgress.get()) {
                    this.ready.set(true);
                    this.tryProcessQueue(false);
                }
            }
        }
        catch (Throwable t) {
            InitFailureStrategy strategy;
            int attemptIdx = attempt + 1;
            if (TbActorMailbox.isUnrecoverable(t)) {
                strategy = InitFailureStrategy.stop();
            } else {
                log.debug("[{}] Failed to init actor, attempt: {}", new Object[]{this.selfId, attempt, t});
                strategy = this.actor.onInitFailure(attempt, t);
            }
            if (strategy.isStop() || this.settings.getMaxActorInitAttempts() > 0 && attemptIdx > this.settings.getMaxActorInitAttempts()) {
                log.info("[{}] Failed to init actor, attempt {}, going to stop attempts.", new Object[]{this.selfId, attempt, t});
                this.stopReason = TbActorStopReason.INIT_FAILED;
                this.destroy(t.getCause());
            }
            if (strategy.getRetryDelay() > 0L) {
                log.info("[{}] Failed to init actor, attempt {}, going to retry in attempts in {}ms", new Object[]{this.selfId, attempt, strategy.getRetryDelay()});
                log.debug("[{}] Error", (Object)this.selfId, (Object)t);
                this.system.getScheduler().schedule(() -> this.dispatcher.getExecutor().execute(() -> this.tryInit(attemptIdx)), strategy.getRetryDelay(), TimeUnit.MILLISECONDS);
            }
            log.info("[{}] Failed to init actor, attempt {}, going to retry immediately", (Object)this.selfId, (Object)attempt);
            log.debug("[{}] Error", (Object)this.selfId, (Object)t);
            this.dispatcher.getExecutor().execute(() -> this.tryInit(attemptIdx));
        }
    }

    private static boolean isUnrecoverable(Throwable t) {
        RecoveryAware recoveryAware;
        if (t instanceof TbActorException && t.getCause() != null) {
            t = t.getCause();
        }
        return t instanceof RecoveryAware && (recoveryAware = (RecoveryAware)t).isUnrecoverable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(TbActorMsg msg, boolean highPriority) {
        if (!this.destroyInProgress.get()) {
            if (highPriority) {
                this.highPriorityMsgs.add(msg);
            } else {
                this.normalPriorityMsgs.add(msg);
            }
            this.tryProcessQueue(true);
        } else if (highPriority && msg.getMsgType().equals((Object)MsgType.RULE_NODE_UPDATED_MSG)) {
            TbActorMailbox tbActorMailbox = this;
            synchronized (tbActorMailbox) {
                if (this.stopReason == TbActorStopReason.INIT_FAILED) {
                    this.destroyInProgress.set(false);
                    this.stopReason = null;
                    this.initActor();
                } else {
                    msg.onTbActorStopped(this.stopReason);
                }
            }
        } else {
            msg.onTbActorStopped(this.stopReason);
        }
    }

    private void tryProcessQueue(boolean newMsg) {
        if (this.ready.get()) {
            if (newMsg || !this.highPriorityMsgs.isEmpty() || !this.normalPriorityMsgs.isEmpty()) {
                if (this.busy.compareAndSet(false, true)) {
                    this.dispatcher.getExecutor().execute(this::processMailbox);
                } else {
                    log.trace("[{}] MessageBox is busy, new msg: {}", (Object)this.selfId, (Object)newMsg);
                }
            } else {
                log.trace("[{}] MessageBox is empty, new msg: {}", (Object)this.selfId, (Object)newMsg);
            }
        } else {
            log.trace("[{}] MessageBox is not ready, new msg: {}", (Object)this.selfId, (Object)newMsg);
        }
    }

    private void processMailbox() {
        boolean noMoreElements = false;
        for (int i = 0; i < this.settings.getActorThroughput(); ++i) {
            TbActorMsg msg = this.highPriorityMsgs.poll();
            if (msg == null) {
                msg = this.normalPriorityMsgs.poll();
            }
            if (msg != null) {
                try {
                    log.trace("[{}] Going to process message: {}", (Object)this.selfId, (Object)msg);
                    this.actor.process(msg);
                }
                catch (TbRuleNodeUpdateException updateException) {
                    this.stopReason = TbActorStopReason.INIT_FAILED;
                    this.destroy(updateException.getCause());
                }
                catch (Throwable t) {
                    log.debug("[{}] Failed to process message: {}", new Object[]{this.selfId, msg, t});
                    ProcessFailureStrategy strategy = this.actor.onProcessFailure(msg, t);
                    if (!strategy.isStop()) continue;
                    this.system.stop(this.selfId);
                }
                continue;
            }
            noMoreElements = true;
            break;
        }
        if (noMoreElements) {
            this.busy.set(false);
            this.dispatcher.getExecutor().execute(() -> this.tryProcessQueue(false));
        } else {
            this.dispatcher.getExecutor().execute(this::processMailbox);
        }
    }

    @Override
    public TbActorId getSelf() {
        return this.selfId;
    }

    @Override
    public void tell(TbActorId target, TbActorMsg actorMsg) {
        this.system.tell(target, actorMsg);
    }

    @Override
    public void broadcastToChildren(TbActorMsg msg) {
        this.broadcastToChildren(msg, false);
    }

    @Override
    public void broadcastToChildren(TbActorMsg msg, boolean highPriority) {
        this.system.broadcastToChildren(this.selfId, msg, highPriority);
    }

    @Override
    public void broadcastToChildrenByType(TbActorMsg msg, EntityType entityType) {
        this.broadcastToChildren(msg, actorId -> entityType.equals((Object)actorId.getEntityType()));
    }

    @Override
    public void broadcastToChildren(TbActorMsg msg, Predicate<TbActorId> childFilter) {
        this.system.broadcastToChildren(this.selfId, childFilter, msg);
    }

    @Override
    public List<TbActorId> filterChildren(Predicate<TbActorId> childFilter) {
        return this.system.filterChildren(this.selfId, childFilter);
    }

    @Override
    public void stop(TbActorId target) {
        this.system.stop(target);
    }

    @Override
    public TbActorRef getOrCreateChildActor(TbActorId actorId, Supplier<String> dispatcher, Supplier<TbActorCreator> creator, Supplier<Boolean> createCondition) {
        TbActorRef actorRef = this.system.getActor(actorId);
        if (actorRef == null && createCondition.get().booleanValue()) {
            return this.system.createChildActor(dispatcher.get(), creator.get(), this.selfId);
        }
        return actorRef;
    }

    public void destroy(Throwable cause) {
        if (this.stopReason == null) {
            this.stopReason = TbActorStopReason.STOPPED;
        }
        this.destroyInProgress.set(true);
        this.dispatcher.getExecutor().execute(() -> {
            try {
                this.ready.set(false);
                this.actor.destroy(this.stopReason, cause);
                this.highPriorityMsgs.removeIf(msg -> {
                    msg.onTbActorStopped(this.stopReason);
                    return true;
                });
                this.normalPriorityMsgs.removeIf(msg -> {
                    msg.onTbActorStopped(this.stopReason);
                    return true;
                });
            }
            catch (Throwable t) {
                log.warn("[{}] Failed to destroy actor: ", (Object)this.selfId, (Object)t);
            }
        });
    }

    @Override
    public TbActorId getActorId() {
        return this.selfId;
    }

    @Override
    public void tell(TbActorMsg actorMsg) {
        this.enqueue(actorMsg, false);
    }

    @Override
    public void tellWithHighPriority(TbActorMsg actorMsg) {
        this.enqueue(actorMsg, true);
    }

    @Generated
    public TbActorSystem getSystem() {
        return this.system;
    }

    @Generated
    public TbActorSystemSettings getSettings() {
        return this.settings;
    }

    @Generated
    public TbActorId getSelfId() {
        return this.selfId;
    }

    @Override
    @Generated
    public TbActorRef getParentRef() {
        return this.parentRef;
    }

    @Generated
    public TbActor getActor() {
        return this.actor;
    }

    @Generated
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Generated
    public ConcurrentLinkedQueue<TbActorMsg> getHighPriorityMsgs() {
        return this.highPriorityMsgs;
    }

    @Generated
    public ConcurrentLinkedQueue<TbActorMsg> getNormalPriorityMsgs() {
        return this.normalPriorityMsgs;
    }

    @Generated
    public AtomicBoolean getBusy() {
        return this.busy;
    }

    @Generated
    public AtomicBoolean getReady() {
        return this.ready;
    }

    @Generated
    public AtomicBoolean getDestroyInProgress() {
        return this.destroyInProgress;
    }

    @Generated
    public TbActorStopReason getStopReason() {
        return this.stopReason;
    }

    @ConstructorProperties(value={"system", "settings", "selfId", "parentRef", "actor", "dispatcher"})
    @Generated
    public TbActorMailbox(TbActorSystem system, TbActorSystemSettings settings, TbActorId selfId, TbActorRef parentRef, TbActor actor, Dispatcher dispatcher) {
        this.system = system;
        this.settings = settings;
        this.selfId = selfId;
        this.parentRef = parentRef;
        this.actor = actor;
        this.dispatcher = dispatcher;
    }
}

