/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.actors.Dispatcher;
import org.thingsboard.server.actors.TbActor;
import org.thingsboard.server.actors.TbActorCreator;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorMailbox;
import org.thingsboard.server.actors.TbActorNotRegisteredException;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbActorSystem;
import org.thingsboard.server.actors.TbActorSystemSettings;
import org.thingsboard.server.common.msg.TbActorMsg;

public class DefaultTbActorSystem
implements TbActorSystem {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbActorSystem.class);
    private final ConcurrentMap<String, Dispatcher> dispatchers = new ConcurrentHashMap<String, Dispatcher>();
    private final ConcurrentMap<TbActorId, TbActorMailbox> actors = new ConcurrentHashMap<TbActorId, TbActorMailbox>();
    private final ConcurrentMap<TbActorId, ReentrantLock> actorCreationLocks = new ConcurrentHashMap<TbActorId, ReentrantLock>();
    private final ConcurrentMap<TbActorId, Set<TbActorId>> parentChildMap = new ConcurrentHashMap<TbActorId, Set<TbActorId>>();
    private final TbActorSystemSettings settings;
    private final ScheduledExecutorService scheduler;

    public DefaultTbActorSystem(TbActorSystemSettings settings) {
        this.settings = settings;
        this.scheduler = ThingsBoardExecutors.newScheduledThreadPool((int)settings.getSchedulerPoolSize(), (String)"actor-system-scheduler");
    }

    @Override
    public void createDispatcher(String dispatcherId, ExecutorService executor) {
        Dispatcher current = this.dispatchers.putIfAbsent(dispatcherId, new Dispatcher(dispatcherId, executor));
        if (current != null) {
            throw new RuntimeException("Dispatcher with id [" + dispatcherId + "] is already registered!");
        }
    }

    @Override
    public void destroyDispatcher(String dispatcherId) {
        Dispatcher dispatcher = (Dispatcher)this.dispatchers.remove(dispatcherId);
        if (dispatcher == null) {
            throw new RuntimeException("Dispatcher with id [" + dispatcherId + "] is not registered!");
        }
        dispatcher.getExecutor().shutdownNow();
    }

    @Override
    public TbActorRef getActor(TbActorId actorId) {
        return (TbActorRef)this.actors.get(actorId);
    }

    @Override
    public TbActorRef createRootActor(String dispatcherId, TbActorCreator creator) {
        return this.createActor(dispatcherId, creator, null);
    }

    @Override
    public TbActorRef createChildActor(String dispatcherId, TbActorCreator creator, TbActorId parent) {
        return this.createActor(dispatcherId, creator, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TbActorRef createActor(String dispatcherId, TbActorCreator creator, TbActorId parent) {
        Dispatcher dispatcher = (Dispatcher)this.dispatchers.get(dispatcherId);
        if (dispatcher == null) {
            log.warn("Dispatcher with id [{}] is not registered!", (Object)dispatcherId);
            throw new RuntimeException("Dispatcher with id [" + dispatcherId + "] is not registered!");
        }
        TbActorId actorId = creator.createActorId();
        TbActorMailbox actorMailbox = (TbActorMailbox)this.actors.get(actorId);
        if (actorMailbox != null) {
            log.debug("Actor with id [{}] is already registered!", (Object)actorId);
        } else {
            Lock actorCreationLock = this.actorCreationLocks.computeIfAbsent(actorId, id -> new ReentrantLock());
            actorCreationLock.lock();
            try {
                actorMailbox = (TbActorMailbox)this.actors.get(actorId);
                if (actorMailbox == null) {
                    log.debug("Creating actor with id [{}]!", (Object)actorId);
                    TbActor actor = creator.createActor();
                    TbActorRef parentRef = null;
                    if (parent != null && (parentRef = this.getActor(parent)) == null) {
                        throw new TbActorNotRegisteredException(parent, "Parent Actor with id [" + String.valueOf(parent) + "] is not registered!");
                    }
                    TbActorMailbox mailbox = new TbActorMailbox(this, this.settings, actorId, parentRef, actor, dispatcher);
                    this.actors.put(actorId, mailbox);
                    mailbox.initActor();
                    actorMailbox = mailbox;
                    if (parent != null) {
                        this.parentChildMap.computeIfAbsent(parent, id -> ConcurrentHashMap.newKeySet()).add(actorId);
                    }
                } else {
                    log.debug("Actor with id [{}] is already registered!", (Object)actorId);
                }
            }
            finally {
                actorCreationLock.unlock();
                this.actorCreationLocks.remove(actorId);
            }
        }
        return actorMailbox;
    }

    @Override
    public void tellWithHighPriority(TbActorId target, TbActorMsg actorMsg) {
        this.tell(target, actorMsg, true);
    }

    @Override
    public void tell(TbActorId target, TbActorMsg actorMsg) {
        this.tell(target, actorMsg, false);
    }

    private void tell(TbActorId target, TbActorMsg actorMsg, boolean highPriority) {
        TbActorMailbox mailbox = (TbActorMailbox)this.actors.get(target);
        if (mailbox == null) {
            throw new TbActorNotRegisteredException(target, "Actor with id [" + String.valueOf(target) + "] is not registered!");
        }
        if (highPriority) {
            mailbox.tellWithHighPriority(actorMsg);
        } else {
            mailbox.tell(actorMsg);
        }
    }

    @Override
    public void broadcastToChildren(TbActorId parent, TbActorMsg msg) {
        this.broadcastToChildren(parent, msg, false);
    }

    @Override
    public void broadcastToChildren(TbActorId parent, TbActorMsg msg, boolean highPriority) {
        this.broadcastToChildren(parent, id -> true, msg, highPriority);
    }

    @Override
    public void broadcastToChildren(TbActorId parent, Predicate<TbActorId> childFilter, TbActorMsg msg) {
        this.broadcastToChildren(parent, childFilter, msg, false);
    }

    private void broadcastToChildren(TbActorId parent, Predicate<TbActorId> childFilter, TbActorMsg msg, boolean highPriority) {
        Set children = (Set)this.parentChildMap.get(parent);
        if (children != null) {
            children.stream().filter(childFilter).forEach(id -> {
                try {
                    this.tell((TbActorId)id, msg, highPriority);
                }
                catch (TbActorNotRegisteredException e) {
                    log.warn("Actor is missing for {}", id);
                }
            });
        }
    }

    @Override
    public List<TbActorId> filterChildren(TbActorId parent, Predicate<TbActorId> childFilter) {
        Set children = (Set)this.parentChildMap.get(parent);
        if (children != null) {
            return children.stream().filter(childFilter).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void stop(TbActorRef actorRef) {
        this.stop(actorRef.getActorId());
    }

    @Override
    public void stop(TbActorId actorId) {
        Set children = (Set)this.parentChildMap.remove(actorId);
        if (children != null) {
            for (TbActorId child : children) {
                this.stop(child);
            }
        }
        this.parentChildMap.values().forEach(parentChildren -> parentChildren.remove(actorId));
        TbActorMailbox mailbox = (TbActorMailbox)this.actors.remove(actorId);
        if (mailbox != null) {
            mailbox.destroy(null);
        }
    }

    @Override
    public void stop() {
        this.dispatchers.values().forEach(dispatcher -> {
            dispatcher.getExecutor().shutdown();
            try {
                dispatcher.getExecutor().awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.warn("[{}] Failed to stop dispatcher", (Object)dispatcher.getDispatcherId(), (Object)e);
            }
        });
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        this.actors.clear();
    }

    @Generated
    public ConcurrentMap<String, Dispatcher> getDispatchers() {
        return this.dispatchers;
    }

    @Generated
    public ConcurrentMap<TbActorId, TbActorMailbox> getActors() {
        return this.actors;
    }

    @Generated
    public ConcurrentMap<TbActorId, ReentrantLock> getActorCreationLocks() {
        return this.actorCreationLocks;
    }

    @Generated
    public ConcurrentMap<TbActorId, Set<TbActorId>> getParentChildMap() {
        return this.parentChildMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTbActorSystem)) {
            return false;
        }
        DefaultTbActorSystem other = (DefaultTbActorSystem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConcurrentMap<String, Dispatcher> this$dispatchers = this.getDispatchers();
        ConcurrentMap<String, Dispatcher> other$dispatchers = other.getDispatchers();
        if (this$dispatchers == null ? other$dispatchers != null : !this$dispatchers.equals(other$dispatchers)) {
            return false;
        }
        ConcurrentMap<TbActorId, TbActorMailbox> this$actors = this.getActors();
        ConcurrentMap<TbActorId, TbActorMailbox> other$actors = other.getActors();
        if (this$actors == null ? other$actors != null : !this$actors.equals(other$actors)) {
            return false;
        }
        ConcurrentMap<TbActorId, ReentrantLock> this$actorCreationLocks = this.getActorCreationLocks();
        ConcurrentMap<TbActorId, ReentrantLock> other$actorCreationLocks = other.getActorCreationLocks();
        if (this$actorCreationLocks == null ? other$actorCreationLocks != null : !this$actorCreationLocks.equals(other$actorCreationLocks)) {
            return false;
        }
        ConcurrentMap<TbActorId, Set<TbActorId>> this$parentChildMap = this.getParentChildMap();
        ConcurrentMap<TbActorId, Set<TbActorId>> other$parentChildMap = other.getParentChildMap();
        if (this$parentChildMap == null ? other$parentChildMap != null : !this$parentChildMap.equals(other$parentChildMap)) {
            return false;
        }
        TbActorSystemSettings this$settings = this.getSettings();
        TbActorSystemSettings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        ScheduledExecutorService this$scheduler = this.getScheduler();
        ScheduledExecutorService other$scheduler = other.getScheduler();
        return !(this$scheduler == null ? other$scheduler != null : !this$scheduler.equals(other$scheduler));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultTbActorSystem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentMap<String, Dispatcher> $dispatchers = this.getDispatchers();
        result = result * 59 + ($dispatchers == null ? 43 : $dispatchers.hashCode());
        ConcurrentMap<TbActorId, TbActorMailbox> $actors = this.getActors();
        result = result * 59 + ($actors == null ? 43 : $actors.hashCode());
        ConcurrentMap<TbActorId, ReentrantLock> $actorCreationLocks = this.getActorCreationLocks();
        result = result * 59 + ($actorCreationLocks == null ? 43 : $actorCreationLocks.hashCode());
        ConcurrentMap<TbActorId, Set<TbActorId>> $parentChildMap = this.getParentChildMap();
        result = result * 59 + ($parentChildMap == null ? 43 : $parentChildMap.hashCode());
        TbActorSystemSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        ScheduledExecutorService $scheduler = this.getScheduler();
        result = result * 59 + ($scheduler == null ? 43 : $scheduler.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultTbActorSystem(dispatchers=" + String.valueOf(this.getDispatchers()) + ", actors=" + String.valueOf(this.getActors()) + ", actorCreationLocks=" + String.valueOf(this.getActorCreationLocks()) + ", parentChildMap=" + String.valueOf(this.getParentChildMap()) + ", settings=" + String.valueOf(this.getSettings()) + ", scheduler=" + String.valueOf(this.getScheduler()) + ")";
    }

    @Generated
    public TbActorSystemSettings getSettings() {
        return this.settings;
    }

    @Override
    @Generated
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }
}

