/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors;

import org.thingsboard.server.actors.InitFailureStrategy;
import org.thingsboard.server.actors.ProcessFailureStrategy;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbActorStopReason;

public interface TbActor {
    public boolean process(TbActorMsg var1);

    public TbActorRef getActorRef();

    default public void init(TbActorCtx ctx) throws TbActorException {
    }

    default public void destroy(TbActorStopReason stopReason, Throwable cause) throws TbActorException {
    }

    default public InitFailureStrategy onInitFailure(int attempt, Throwable t) {
        return InitFailureStrategy.retryWithDelay(5000L * (long)attempt);
    }

    default public ProcessFailureStrategy onProcessFailure(Throwable t) {
        if (t instanceof Error) {
            return ProcessFailureStrategy.stop();
        }
        return ProcessFailureStrategy.resume();
    }
}

