/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.utils;

import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.util.KvProtoUtil;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.BaseCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.ScriptCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SimpleCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;

public class CalculatedFieldUtils {
    public static TransportProtos.CalculatedFieldIdProto toProto(CalculatedFieldId cfId) {
        return TransportProtos.CalculatedFieldIdProto.newBuilder().setCalculatedFieldIdMSB(cfId.getId().getMostSignificantBits()).setCalculatedFieldIdLSB(cfId.getId().getLeastSignificantBits()).build();
    }

    public static TransportProtos.CalculatedFieldEntityCtxIdProto toProto(CalculatedFieldEntityCtxId ctxId) {
        return TransportProtos.CalculatedFieldEntityCtxIdProto.newBuilder().setTenantIdMSB(ctxId.tenantId().getId().getMostSignificantBits()).setTenantIdLSB(ctxId.tenantId().getId().getLeastSignificantBits()).setCalculatedFieldIdMSB(ctxId.cfId().getId().getMostSignificantBits()).setCalculatedFieldIdLSB(ctxId.cfId().getId().getLeastSignificantBits()).setEntityType(ctxId.entityId().getEntityType().name()).setEntityIdMSB(ctxId.entityId().getId().getMostSignificantBits()).setEntityIdLSB(ctxId.entityId().getId().getLeastSignificantBits()).build();
    }

    public static CalculatedFieldEntityCtxId fromProto(TransportProtos.CalculatedFieldEntityCtxIdProto ctxIdProto) {
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(ctxIdProto.getTenantIdMSB(), ctxIdProto.getTenantIdLSB()));
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((String)ctxIdProto.getEntityType(), (UUID)new UUID(ctxIdProto.getEntityIdMSB(), ctxIdProto.getEntityIdLSB()));
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(new UUID(ctxIdProto.getCalculatedFieldIdMSB(), ctxIdProto.getCalculatedFieldIdLSB()));
        return new CalculatedFieldEntityCtxId(tenantId, calculatedFieldId, entityId);
    }

    public static TransportProtos.CalculatedFieldStateProto toProto(CalculatedFieldEntityCtxId stateId, CalculatedFieldState state) {
        TransportProtos.CalculatedFieldStateProto.Builder builder = TransportProtos.CalculatedFieldStateProto.newBuilder().setId(CalculatedFieldUtils.toProto(stateId)).setType(state.getType().name());
        state.getArguments().forEach((argName, argEntry) -> {
            if (argEntry instanceof SingleValueArgumentEntry) {
                SingleValueArgumentEntry singleValueArgumentEntry = (SingleValueArgumentEntry)argEntry;
                builder.addSingleValueArguments(CalculatedFieldUtils.toSingleValueArgumentProto(argName, singleValueArgumentEntry));
            } else if (argEntry instanceof TsRollingArgumentEntry) {
                TsRollingArgumentEntry rollingArgumentEntry = (TsRollingArgumentEntry)argEntry;
                builder.addRollingValueArguments(CalculatedFieldUtils.toRollingArgumentProto(argName, rollingArgumentEntry));
            }
        });
        return builder.build();
    }

    public static TransportProtos.SingleValueArgumentProto toSingleValueArgumentProto(String argName, SingleValueArgumentEntry entry) {
        TransportProtos.SingleValueArgumentProto.Builder builder = TransportProtos.SingleValueArgumentProto.newBuilder().setArgName(argName);
        if (entry.getKvEntryValue() != null) {
            builder.setValue(KvProtoUtil.toTsValueProto((long)entry.getTs(), (KvEntry)entry.getKvEntryValue()));
        }
        Optional.ofNullable(entry.getVersion()).ifPresent(arg_0 -> ((TransportProtos.SingleValueArgumentProto.Builder)builder).setVersion(arg_0));
        return builder.build();
    }

    public static TransportProtos.TsRollingArgumentProto toRollingArgumentProto(String argName, TsRollingArgumentEntry entry) {
        TransportProtos.TsRollingArgumentProto.Builder builder = TransportProtos.TsRollingArgumentProto.newBuilder().setKey(argName).setLimit(entry.getLimit().intValue()).setTimeWindow(entry.getTimeWindow().longValue());
        entry.getTsRecords().forEach((ts, value) -> builder.addTsValue(TransportProtos.TsDoubleValProto.newBuilder().setTs(ts.longValue()).setValue(value.doubleValue()).build()));
        return builder.build();
    }

    public static CalculatedFieldState fromProto(TransportProtos.CalculatedFieldStateProto proto) {
        if (StringUtils.isEmpty((String)proto.getType())) {
            return null;
        }
        CalculatedFieldType type = CalculatedFieldType.valueOf((String)proto.getType());
        BaseCalculatedFieldState state = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case CalculatedFieldType.SIMPLE -> new SimpleCalculatedFieldState();
            case CalculatedFieldType.SCRIPT -> new ScriptCalculatedFieldState();
        };
        proto.getSingleValueArgumentsList().forEach(argProto -> state.getArguments().put(argProto.getArgName(), CalculatedFieldUtils.fromSingleValueArgumentProto(argProto)));
        if (CalculatedFieldType.SCRIPT.equals((Object)type)) {
            proto.getRollingValueArgumentsList().forEach(argProto -> state.getArguments().put(argProto.getKey(), CalculatedFieldUtils.fromRollingArgumentProto(argProto)));
        }
        return state;
    }

    public static SingleValueArgumentEntry fromSingleValueArgumentProto(TransportProtos.SingleValueArgumentProto proto) {
        if (!proto.hasValue()) {
            return new SingleValueArgumentEntry();
        }
        TransportProtos.TsValueProto tsValueProto = proto.getValue();
        return new SingleValueArgumentEntry(tsValueProto.getTs(), (BasicKvEntry)KvProtoUtil.fromTsValueProto((String)proto.getArgName(), (TransportProtos.TsValueProto)tsValueProto), proto.getVersion());
    }

    public static TsRollingArgumentEntry fromRollingArgumentProto(TransportProtos.TsRollingArgumentProto proto) {
        TreeMap<Long, Double> tsRecords = new TreeMap<Long, Double>();
        proto.getTsValueList().forEach(tsValueProto -> tsRecords.put(tsValueProto.getTs(), tsValueProto.getValue()));
        return new TsRollingArgumentEntry(tsRecords, proto.getLimit(), proto.getTimeWindow());
    }
}

