/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws.telemetry.sub;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.query.TsValue;
import org.thingsboard.server.service.subscription.SubscriptionErrorCode;

public class TelemetrySubscriptionUpdate {
    private final int subscriptionId;
    private int errorCode;
    private String errorMsg;
    private Map<String, List<Object>> data;

    public TelemetrySubscriptionUpdate(int subscriptionId, List<TsKvEntry> data) {
        this.subscriptionId = subscriptionId;
        this.data = new TreeMap<String, List<Object>>();
        if (data != null) {
            for (TsKvEntry tsEntry : data) {
                List values = this.data.computeIfAbsent(tsEntry.getKey(), k -> new ArrayList());
                Object[] value = new Object[]{tsEntry.getTs(), tsEntry.getValueAsString()};
                values.add(value);
            }
        }
    }

    public TelemetrySubscriptionUpdate(int subscriptionId, Map<String, List<Object>> data) {
        this.subscriptionId = subscriptionId;
        this.data = data;
    }

    public TelemetrySubscriptionUpdate(int subscriptionId, SubscriptionErrorCode errorCode) {
        this(subscriptionId, errorCode, null);
    }

    public TelemetrySubscriptionUpdate(int subscriptionId, SubscriptionErrorCode errorCode, String errorMsg) {
        this.subscriptionId = subscriptionId;
        this.errorCode = errorCode.getCode();
        this.errorMsg = errorMsg != null ? errorMsg : errorCode.getDefaultMsg();
    }

    @JsonIgnore
    public Map<String, List<TsValue>> getValues() {
        if (this.data == null || this.data.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<TsValue>> data = new HashMap<String, List<TsValue>>();
        this.data.forEach((key, entries) -> {
            if (entries.isEmpty()) {
                return;
            }
            ArrayList values = new ArrayList(entries.size());
            entries.forEach(object -> {
                Object[] entry;
                if (!(object instanceof Object[]) || (entry = (Object[])object).length < 2) {
                    return;
                }
                TsValue tsValue = new TsValue(((Long)entry[0]).longValue(), (String)entry[1]);
                values.add(tsValue);
            });
            data.put((String)key, values);
        });
        return data;
    }

    public Map<String, Long> getLatestValues() {
        if (this.data == null) {
            return Collections.emptyMap();
        }
        return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            List data = (List)e.getValue();
            Object[] latest = (Object[])data.get(data.size() - 1);
            return (long)((Long)latest[0]);
        }));
    }

    public String toString() {
        StringBuilder result = new StringBuilder("TelemetrySubscriptionUpdate [subscriptionId=" + this.subscriptionId + ", errorCode=" + this.errorCode + ", errorMsg=" + this.errorMsg + ", data=");
        this.data.forEach((k, v) -> {
            result.append((String)k).append("=[");
            for (Object a : v) {
                result.append(Arrays.toString((Object[])a)).append("|");
            }
            result.append("]");
        });
        return result.toString();
    }

    @Generated
    public int getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Generated
    public Map<String, List<Object>> getData() {
        return this.data;
    }

    @ConstructorProperties(value={"subscriptionId", "errorCode", "errorMsg", "data"})
    @Generated
    public TelemetrySubscriptionUpdate(int subscriptionId, int errorCode, String errorMsg, Map<String, List<Object>> data) {
        this.subscriptionId = subscriptionId;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.data = data;
    }

    @Generated
    public TelemetrySubscriptionUpdate withSubscriptionId(int subscriptionId) {
        return this.subscriptionId == subscriptionId ? this : new TelemetrySubscriptionUpdate(subscriptionId, this.errorCode, this.errorMsg, this.data);
    }
}

