/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws.telemetry.cmd.v2;

import java.util.List;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.AggregationParams;
import org.thingsboard.server.common.data.kv.IntervalType;

public interface GetTsCmd {
    public long getStartTs();

    public long getEndTs();

    public List<String> getKeys();

    public IntervalType getIntervalType();

    public long getInterval();

    public String getTimeZoneId();

    public int getLimit();

    public Aggregation getAgg();

    public boolean isFetchLatestPreviousPoint();

    default public AggregationParams toAggregationParams() {
        Aggregation agg = this.getAgg();
        IntervalType intervalType = this.getIntervalType();
        if (agg == null || Aggregation.NONE.equals((Object)agg)) {
            return AggregationParams.none();
        }
        if (intervalType == null || IntervalType.MILLISECONDS.equals((Object)intervalType)) {
            return AggregationParams.milliseconds((Aggregation)agg, (long)this.getInterval());
        }
        return AggregationParams.calendar((Aggregation)agg, (IntervalType)intervalType, (String)this.getTimeZoneId());
    }
}

