/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl.rpc;

import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.dao.rpc.RpcDao;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.TbCoreComponent;

@TbCoreComponent
@Service
public class RpcCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RpcCleanUpService.class);
    @Value(value="${sql.ttl.rpc.enabled}")
    private boolean ttlTaskExecutionEnabled;
    private final TenantService tenantService;
    private final PartitionService partitionService;
    private final TbTenantProfileCache tenantProfileCache;
    private final RpcDao rpcDao;

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.rpc.checking_interval})}", fixedDelayString="${sql.ttl.rpc.checking_interval}")
    public void cleanUp() {
        if (this.ttlTaskExecutionEnabled) {
            PageData tenantsIds;
            PageLink tenantsBatchRequest = new PageLink(10000, 0);
            do {
                tenantsIds = this.tenantService.findTenantsIds(tenantsBatchRequest);
                for (TenantId tenantId : tenantsIds.getData()) {
                    Optional tenantProfileConfiguration;
                    if (!this.partitionService.resolve(ServiceType.TB_CORE, tenantId, (EntityId)tenantId).isMyPartition() || (tenantProfileConfiguration = this.tenantProfileCache.get(tenantId).getProfileConfiguration()).isEmpty() || ((DefaultTenantProfileConfiguration)tenantProfileConfiguration.get()).getRpcTtlDays() == 0) continue;
                    long ttl = TimeUnit.DAYS.toMillis(((DefaultTenantProfileConfiguration)tenantProfileConfiguration.get()).getRpcTtlDays());
                    long expirationTime = System.currentTimeMillis() - ttl;
                    int totalRemoved = this.rpcDao.deleteOutdatedRpcByTenantId(tenantId, Long.valueOf(expirationTime));
                    if (totalRemoved <= 0) continue;
                    log.info("Removed {} outdated rpc(s) for tenant {} older than {}", new Object[]{totalRemoved, tenantId, new Date(expirationTime)});
                }
                tenantsBatchRequest = tenantsBatchRequest.nextPageLink();
            } while (tenantsIds.hasNext());
        }
    }

    @ConstructorProperties(value={"tenantService", "partitionService", "tenantProfileCache", "rpcDao"})
    @Generated
    public RpcCleanUpService(TenantService tenantService, PartitionService partitionService, TbTenantProfileCache tenantProfileCache, RpcDao rpcDao) {
        this.tenantService = tenantService;
        this.partitionService = partitionService;
        this.tenantProfileCache = tenantProfileCache;
        this.rpcDao = rpcDao;
    }
}

