/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.telemetry;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.AggregationParams;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.IntervalType;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.service.security.AccessValidator;
import org.thingsboard.server.service.security.ValidationResult;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.telemetry.TbTelemetryService;

@Service
public class DefaultTbTelemetryService
implements TbTelemetryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbTelemetryService.class);
    private final TimeseriesService tsService;
    private final AccessValidator accessValidator;

    @Override
    public ListenableFuture<List<TsKvEntry>> getTimeseries(final EntityId entityId, final List<String> keys, final Long startTs, final Long endTs, final IntervalType intervalType, final Long interval, final String timeZone, final Integer limit, final Aggregation agg, final String orderBy, Boolean useStrictDataTypes, final SecurityUser currentUser) {
        final SettableFuture future = SettableFuture.create();
        this.accessValidator.validate(currentUser, Operation.READ_TELEMETRY, entityId, new FutureCallback<ValidationResult>(){

            public void onSuccess(ValidationResult validationResult) {
                try {
                    AggregationParams params = Aggregation.NONE.equals((Object)agg) ? AggregationParams.none() : (intervalType == null || IntervalType.MILLISECONDS.equals((Object)intervalType) ? (interval == 0L ? AggregationParams.none() : AggregationParams.milliseconds((Aggregation)agg, (long)interval)) : AggregationParams.calendar((Aggregation)agg, (IntervalType)intervalType, (String)timeZone));
                    List queries = keys.stream().map(key -> new BaseReadTsKvQuery(key, startTs.longValue(), endTs.longValue(), params, limit.intValue(), orderBy)).collect(Collectors.toList());
                    Futures.addCallback((ListenableFuture)DefaultTbTelemetryService.this.tsService.findAll(currentUser.getTenantId(), entityId, queries), (FutureCallback)new FutureCallback<List<TsKvEntry>>(){

                        public void onSuccess(List<TsKvEntry> result) {
                            future.set(result);
                        }

                        public void onFailure(Throwable t) {
                            future.setException(t);
                        }
                    }, (Executor)MoreExecutors.directExecutor());
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Throwable t) {
                future.setException(t);
            }
        });
        return future;
    }

    @ConstructorProperties(value={"tsService", "accessValidator"})
    @Generated
    public DefaultTbTelemetryService(TimeseriesService tsService, AccessValidator accessValidator) {
        this.tsService = tsService;
        this.accessValidator = accessValidator;
    }
}

