/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.sync.ie.EntityImportResult;
import org.thingsboard.server.common.data.sync.ie.EntityImportSettings;
import org.thingsboard.server.common.data.sync.vc.EntityTypeLoadResult;
import org.thingsboard.server.common.data.util.ThrowingRunnable;
import org.thingsboard.server.service.sync.vc.data.ReimportTask;

public class EntitiesImportCtx {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntitiesImportCtx.class);
    private final UUID requestId;
    private final User user;
    private final String versionId;
    private final Map<EntityType, EntityTypeLoadResult> results = new HashMap<EntityType, EntityTypeLoadResult>();
    private final Map<EntityType, Set<EntityId>> importedEntities = new HashMap<EntityType, Set<EntityId>>();
    private final Map<EntityId, ReimportTask> toReimport = new HashMap<EntityId, ReimportTask>();
    private final Map<EntityId, ThrowingRunnable> referenceCallbacks = new HashMap<EntityId, ThrowingRunnable>();
    private final List<ThrowingRunnable> eventCallbacks = new ArrayList<ThrowingRunnable>();
    private final Map<EntityId, EntityId> externalToInternalIdMap = new HashMap<EntityId, EntityId>();
    private final Set<EntityId> notFoundIds = new HashSet<EntityId>();
    private final Set<EntityRelation> relations = new LinkedHashSet<EntityRelation>();
    private boolean finalImportAttempt = false;
    private EntityImportSettings settings;
    private EntityImportResult<?> currentImportResult;
    private boolean rollbackOnError;

    public EntitiesImportCtx(UUID requestId, User user, String versionId) {
        this(requestId, user, versionId, null);
    }

    public EntitiesImportCtx(UUID requestId, User user, String versionId, EntityImportSettings settings) {
        this.requestId = requestId;
        this.user = user;
        this.versionId = versionId;
        this.settings = settings;
    }

    public TenantId getTenantId() {
        return this.user.getTenantId();
    }

    public boolean isFindExistingByName() {
        return this.getSettings().isFindExistingByName();
    }

    public boolean isUpdateRelations() {
        return this.getSettings().isUpdateRelations();
    }

    public boolean isSaveAttributes() {
        return this.getSettings().isSaveAttributes();
    }

    public boolean isSaveCredentials() {
        return this.getSettings().isSaveCredentials();
    }

    public boolean isSaveCalculatedFields() {
        return this.getSettings().isSaveCalculatedFields();
    }

    public EntityId getInternalId(EntityId externalId) {
        EntityId result = this.externalToInternalIdMap.get(externalId);
        log.debug("[{}][{}] Local cache {} for id", new Object[]{externalId.getEntityType(), externalId.getId(), result != null ? "hit" : "miss"});
        return result;
    }

    public void putInternalId(EntityId externalId, EntityId internalId) {
        log.debug("[{}][{}] Local cache put: {}", new Object[]{externalId.getEntityType(), externalId.getId(), internalId});
        this.externalToInternalIdMap.put(externalId, internalId);
    }

    public void registerResult(EntityType entityType, boolean created) {
        EntityTypeLoadResult result = this.results.computeIfAbsent(entityType, EntityTypeLoadResult::new);
        if (created) {
            result.setCreated(result.getCreated() + 1);
        } else {
            result.setUpdated(result.getUpdated() + 1);
        }
    }

    public void registerDeleted(EntityType entityType) {
        EntityTypeLoadResult result = this.results.computeIfAbsent(entityType, EntityTypeLoadResult::new);
        result.setDeleted(result.getDeleted() + 1);
    }

    public void addRelations(Collection<EntityRelation> values) {
        this.relations.addAll(values);
    }

    public void addReferenceCallback(EntityId externalId, ThrowingRunnable tr) {
        if (tr != null) {
            this.referenceCallbacks.put(externalId, tr);
        }
    }

    public void addEventCallback(ThrowingRunnable tr) {
        if (tr != null) {
            this.eventCallbacks.add(tr);
        }
    }

    public void registerNotFound(EntityId externalId) {
        this.notFoundIds.add(externalId);
    }

    public boolean isNotFound(EntityId externalId) {
        return this.notFoundIds.contains(externalId);
    }

    @Generated
    public UUID getRequestId() {
        return this.requestId;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public String getVersionId() {
        return this.versionId;
    }

    @Generated
    public Map<EntityType, EntityTypeLoadResult> getResults() {
        return this.results;
    }

    @Generated
    public Map<EntityType, Set<EntityId>> getImportedEntities() {
        return this.importedEntities;
    }

    @Generated
    public Map<EntityId, ReimportTask> getToReimport() {
        return this.toReimport;
    }

    @Generated
    public Map<EntityId, ThrowingRunnable> getReferenceCallbacks() {
        return this.referenceCallbacks;
    }

    @Generated
    public List<ThrowingRunnable> getEventCallbacks() {
        return this.eventCallbacks;
    }

    @Generated
    public Map<EntityId, EntityId> getExternalToInternalIdMap() {
        return this.externalToInternalIdMap;
    }

    @Generated
    public Set<EntityId> getNotFoundIds() {
        return this.notFoundIds;
    }

    @Generated
    public Set<EntityRelation> getRelations() {
        return this.relations;
    }

    @Generated
    public boolean isFinalImportAttempt() {
        return this.finalImportAttempt;
    }

    @Generated
    public EntityImportSettings getSettings() {
        return this.settings;
    }

    @Generated
    public EntityImportResult<?> getCurrentImportResult() {
        return this.currentImportResult;
    }

    @Generated
    public boolean isRollbackOnError() {
        return this.rollbackOnError;
    }

    @Generated
    public void setFinalImportAttempt(boolean finalImportAttempt) {
        this.finalImportAttempt = finalImportAttempt;
    }

    @Generated
    public void setSettings(EntityImportSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setCurrentImportResult(EntityImportResult<?> currentImportResult) {
        this.currentImportResult = currentImportResult;
    }

    @Generated
    public void setRollbackOnError(boolean rollbackOnError) {
        this.rollbackOnError = rollbackOnError;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntitiesImportCtx)) {
            return false;
        }
        EntitiesImportCtx other = (EntitiesImportCtx)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFinalImportAttempt() != other.isFinalImportAttempt()) {
            return false;
        }
        if (this.isRollbackOnError() != other.isRollbackOnError()) {
            return false;
        }
        UUID this$requestId = this.getRequestId();
        UUID other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !((Object)this$requestId).equals(other$requestId)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$versionId = this.getVersionId();
        String other$versionId = other.getVersionId();
        if (this$versionId == null ? other$versionId != null : !this$versionId.equals(other$versionId)) {
            return false;
        }
        Map<EntityType, EntityTypeLoadResult> this$results = this.getResults();
        Map<EntityType, EntityTypeLoadResult> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        Map<EntityType, Set<EntityId>> this$importedEntities = this.getImportedEntities();
        Map<EntityType, Set<EntityId>> other$importedEntities = other.getImportedEntities();
        if (this$importedEntities == null ? other$importedEntities != null : !((Object)this$importedEntities).equals(other$importedEntities)) {
            return false;
        }
        Map<EntityId, ReimportTask> this$toReimport = this.getToReimport();
        Map<EntityId, ReimportTask> other$toReimport = other.getToReimport();
        if (this$toReimport == null ? other$toReimport != null : !((Object)this$toReimport).equals(other$toReimport)) {
            return false;
        }
        Map<EntityId, ThrowingRunnable> this$referenceCallbacks = this.getReferenceCallbacks();
        Map<EntityId, ThrowingRunnable> other$referenceCallbacks = other.getReferenceCallbacks();
        if (this$referenceCallbacks == null ? other$referenceCallbacks != null : !((Object)this$referenceCallbacks).equals(other$referenceCallbacks)) {
            return false;
        }
        List<ThrowingRunnable> this$eventCallbacks = this.getEventCallbacks();
        List<ThrowingRunnable> other$eventCallbacks = other.getEventCallbacks();
        if (this$eventCallbacks == null ? other$eventCallbacks != null : !((Object)this$eventCallbacks).equals(other$eventCallbacks)) {
            return false;
        }
        Map<EntityId, EntityId> this$externalToInternalIdMap = this.getExternalToInternalIdMap();
        Map<EntityId, EntityId> other$externalToInternalIdMap = other.getExternalToInternalIdMap();
        if (this$externalToInternalIdMap == null ? other$externalToInternalIdMap != null : !((Object)this$externalToInternalIdMap).equals(other$externalToInternalIdMap)) {
            return false;
        }
        Set<EntityId> this$notFoundIds = this.getNotFoundIds();
        Set<EntityId> other$notFoundIds = other.getNotFoundIds();
        if (this$notFoundIds == null ? other$notFoundIds != null : !((Object)this$notFoundIds).equals(other$notFoundIds)) {
            return false;
        }
        Set<EntityRelation> this$relations = this.getRelations();
        Set<EntityRelation> other$relations = other.getRelations();
        if (this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations)) {
            return false;
        }
        EntityImportSettings this$settings = this.getSettings();
        EntityImportSettings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        EntityImportResult<?> this$currentImportResult = this.getCurrentImportResult();
        EntityImportResult<?> other$currentImportResult = other.getCurrentImportResult();
        return !(this$currentImportResult == null ? other$currentImportResult != null : !this$currentImportResult.equals(other$currentImportResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntitiesImportCtx;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFinalImportAttempt() ? 79 : 97);
        result = result * 59 + (this.isRollbackOnError() ? 79 : 97);
        UUID $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : ((Object)$requestId).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $versionId = this.getVersionId();
        result = result * 59 + ($versionId == null ? 43 : $versionId.hashCode());
        Map<EntityType, EntityTypeLoadResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        Map<EntityType, Set<EntityId>> $importedEntities = this.getImportedEntities();
        result = result * 59 + ($importedEntities == null ? 43 : ((Object)$importedEntities).hashCode());
        Map<EntityId, ReimportTask> $toReimport = this.getToReimport();
        result = result * 59 + ($toReimport == null ? 43 : ((Object)$toReimport).hashCode());
        Map<EntityId, ThrowingRunnable> $referenceCallbacks = this.getReferenceCallbacks();
        result = result * 59 + ($referenceCallbacks == null ? 43 : ((Object)$referenceCallbacks).hashCode());
        List<ThrowingRunnable> $eventCallbacks = this.getEventCallbacks();
        result = result * 59 + ($eventCallbacks == null ? 43 : ((Object)$eventCallbacks).hashCode());
        Map<EntityId, EntityId> $externalToInternalIdMap = this.getExternalToInternalIdMap();
        result = result * 59 + ($externalToInternalIdMap == null ? 43 : ((Object)$externalToInternalIdMap).hashCode());
        Set<EntityId> $notFoundIds = this.getNotFoundIds();
        result = result * 59 + ($notFoundIds == null ? 43 : ((Object)$notFoundIds).hashCode());
        Set<EntityRelation> $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        EntityImportSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        EntityImportResult<?> $currentImportResult = this.getCurrentImportResult();
        result = result * 59 + ($currentImportResult == null ? 43 : $currentImportResult.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntitiesImportCtx(requestId=" + String.valueOf(this.getRequestId()) + ", user=" + String.valueOf(this.getUser()) + ", versionId=" + this.getVersionId() + ", results=" + String.valueOf(this.getResults()) + ", importedEntities=" + String.valueOf(this.getImportedEntities()) + ", toReimport=" + String.valueOf(this.getToReimport()) + ", referenceCallbacks=" + String.valueOf(this.getReferenceCallbacks()) + ", eventCallbacks=" + String.valueOf(this.getEventCallbacks()) + ", externalToInternalIdMap=" + String.valueOf(this.getExternalToInternalIdMap()) + ", notFoundIds=" + String.valueOf(this.getNotFoundIds()) + ", relations=" + String.valueOf(this.getRelations()) + ", finalImportAttempt=" + this.isFinalImportAttempt() + ", settings=" + String.valueOf(this.getSettings()) + ", currentImportResult=" + String.valueOf(this.getCurrentImportResult()) + ", rollbackOnError=" + this.isRollbackOnError() + ")";
    }
}

