/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.sync.vc.BranchInfo;
import org.thingsboard.server.common.data.sync.vc.EntityDataDiff;
import org.thingsboard.server.common.data.sync.vc.EntityDataInfo;
import org.thingsboard.server.common.data.sync.vc.EntityVersion;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.data.sync.vc.VersionCreationResult;
import org.thingsboard.server.common.data.sync.vc.VersionLoadResult;
import org.thingsboard.server.common.data.sync.vc.VersionedEntityInfo;
import org.thingsboard.server.common.data.sync.vc.request.create.VersionCreateRequest;
import org.thingsboard.server.common.data.sync.vc.request.load.VersionLoadRequest;

public interface EntitiesVersionControlService {
    public ListenableFuture<UUID> saveEntitiesVersion(User var1, VersionCreateRequest var2) throws Exception;

    public VersionCreationResult getVersionCreateStatus(User var1, UUID var2) throws ThingsboardException;

    public ListenableFuture<PageData<EntityVersion>> listEntityVersions(TenantId var1, String var2, EntityId var3, PageLink var4) throws Exception;

    public ListenableFuture<PageData<EntityVersion>> listEntityTypeVersions(TenantId var1, String var2, EntityType var3, PageLink var4) throws Exception;

    public ListenableFuture<PageData<EntityVersion>> listVersions(TenantId var1, String var2, PageLink var3) throws Exception;

    public ListenableFuture<List<VersionedEntityInfo>> listEntitiesAtVersion(TenantId var1, String var2, EntityType var3) throws Exception;

    public ListenableFuture<List<VersionedEntityInfo>> listAllEntitiesAtVersion(TenantId var1, String var2) throws Exception;

    public UUID loadEntitiesVersion(User var1, VersionLoadRequest var2) throws Exception;

    public VersionLoadResult getVersionLoadStatus(User var1, UUID var2) throws ThingsboardException;

    public ListenableFuture<EntityDataDiff> compareEntityDataToVersion(User var1, EntityId var2, String var3) throws Exception;

    public ListenableFuture<List<BranchInfo>> listBranches(TenantId var1) throws Exception;

    public RepositorySettings getVersionControlSettings(TenantId var1);

    public ListenableFuture<RepositorySettings> saveVersionControlSettings(TenantId var1, RepositorySettings var2);

    public ListenableFuture<Void> deleteVersionControlSettings(TenantId var1);

    public ListenableFuture<Void> checkVersionControlAccess(TenantId var1, RepositorySettings var2) throws Exception;

    public ListenableFuture<UUID> autoCommit(User var1, EntityId var2);

    public ListenableFuture<UUID> autoCommit(User var1, EntityType var2, List<UUID> var3);

    public ListenableFuture<EntityDataInfo> getEntityDataInfo(User var1, EntityId var2, String var3);
}

