/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.api.client.util.Objects;
import com.google.common.util.concurrent.FutureCallback;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasDefaultOption;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.sync.ie.AttributeExportData;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.ie.EntityImportResult;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.relation.RelationDao;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.service.action.EntityActionService;
import org.thingsboard.server.service.entitiy.TbLogEntityActionService;
import org.thingsboard.server.service.sync.ie.exporting.ExportableEntitiesService;
import org.thingsboard.server.service.sync.ie.importing.EntityImportService;
import org.thingsboard.server.service.sync.ie.importing.impl.MissingEntityException;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

public abstract class BaseEntityImportService<I extends EntityId, E extends ExportableEntity<I>, D extends EntityExportData<E>>
implements EntityImportService<I, E, D> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseEntityImportService.class);
    @Autowired
    @Lazy
    private ExportableEntitiesService entitiesService;
    @Autowired
    private CalculatedFieldService calculatedFieldService;
    @Autowired
    private RelationService relationService;
    @Autowired
    private RelationDao relationDao;
    @Autowired
    private TelemetrySubscriptionService tsSubService;
    @Autowired
    protected EntityActionService entityActionService;
    @Autowired
    protected TbClusterService clusterService;
    @Autowired
    protected TbLogEntityActionService logEntityActionService;

    @Override
    public EntityImportResult<E> importEntity(EntitiesImportCtx ctx, D exportData) throws ThingsboardException {
        EntityImportResult importResult = new EntityImportResult();
        ctx.setCurrentImportResult(importResult);
        importResult.setEntityType(this.getEntityType());
        IdProvider idProvider = new IdProvider(ctx, importResult);
        ExportableEntity entity = exportData.getEntity();
        entity.setExternalId((EntityId)entity.getId());
        ExportableEntity existingEntity = this.findExistingEntity(ctx, entity, idProvider);
        importResult.setOldEntity(existingEntity);
        this.setOwner(ctx.getTenantId(), entity, idProvider);
        if (existingEntity == null) {
            entity.setId(null);
        } else {
            entity.setId((EntityId)existingEntity.getId());
            entity.setCreatedTime(existingEntity.getCreatedTime());
        }
        ExportableEntity prepared = this.prepare(ctx, entity, existingEntity, exportData, idProvider);
        CompareResult compareResult = this.compare(ctx, exportData, prepared, existingEntity);
        if (compareResult.isUpdateNeeded()) {
            ExportableEntity savedEntity = this.saveOrUpdate(ctx, prepared, exportData, idProvider, compareResult);
            boolean created = existingEntity == null;
            importResult.setCreated(created);
            importResult.setUpdated(!created);
            importResult.setSavedEntity(savedEntity);
            ctx.putInternalId(exportData.getExternalId(), (EntityId)savedEntity.getId());
        } else {
            importResult.setSavedEntity(existingEntity);
            ctx.putInternalId(exportData.getExternalId(), (EntityId)existingEntity.getId());
            importResult.setUpdatedRelatedEntities(this.updateRelatedEntitiesIfUnmodified(ctx, prepared, exportData, idProvider));
        }
        this.processAfterSaved(ctx, importResult, exportData, idProvider);
        return importResult;
    }

    protected boolean updateRelatedEntitiesIfUnmodified(EntitiesImportCtx ctx, E prepared, D exportData, IdProvider idProvider) {
        return this.importCalculatedFields(ctx, prepared, exportData, idProvider);
    }

    @Override
    public abstract EntityType getEntityType();

    protected abstract void setOwner(TenantId var1, E var2, IdProvider var3);

    protected abstract E prepare(EntitiesImportCtx var1, E var2, E var3, D var4, IdProvider var5);

    protected CompareResult compare(EntitiesImportCtx ctx, D exportData, E prepared, E existing) {
        if (existing == null) {
            log.debug("[{}] Found new entity.", (Object)prepared.getId());
            return new CompareResult(true);
        }
        E newCopy = this.deepCopy(prepared);
        E existingCopy = this.deepCopy(existing);
        this.cleanupForComparison(newCopy);
        this.cleanupForComparison(existingCopy);
        boolean updateNeeded = this.isUpdateNeeded(ctx, exportData, newCopy, existingCopy);
        boolean externalIdChangedOnly = false;
        if (updateNeeded) {
            log.debug("[{}] Found update.", (Object)prepared.getId());
            log.debug("[{}] From: {}", (Object)prepared.getId(), newCopy);
            log.debug("[{}] To: {}", (Object)prepared.getId(), existingCopy);
            this.cleanupExternalId(newCopy);
            this.cleanupExternalId(existingCopy);
            externalIdChangedOnly = newCopy.equals(existingCopy);
        }
        return new CompareResult(updateNeeded, externalIdChangedOnly);
    }

    protected boolean isUpdateNeeded(EntitiesImportCtx ctx, D exportData, E prepared, E existing) {
        return !prepared.equals(existing);
    }

    protected abstract E deepCopy(E var1);

    protected void cleanupForComparison(E e) {
        e.setTenantId(null);
        e.setCreatedTime(0L);
        if (e instanceof HasVersion) {
            HasVersion hasVersion = (HasVersion)e;
            hasVersion.setVersion(null);
        }
    }

    protected void cleanupExternalId(E e) {
        e.setExternalId(null);
    }

    protected abstract E saveOrUpdate(EntitiesImportCtx var1, E var2, D var3, IdProvider var4, CompareResult var5);

    protected void processAfterSaved(EntitiesImportCtx ctx, EntityImportResult<E> importResult, D exportData, IdProvider idProvider) throws ThingsboardException {
        ExportableEntity savedEntity = importResult.getSavedEntity();
        ExportableEntity oldEntity = importResult.getOldEntity();
        if (importResult.isCreated() || importResult.isUpdated()) {
            importResult.addSendEventsCallback(() -> this.onEntitySaved(ctx.getUser(), savedEntity, oldEntity));
        }
        if (ctx.isUpdateRelations() && exportData.getRelations() != null) {
            this.importRelations(ctx, exportData.getRelations(), importResult, idProvider);
        }
        if (ctx.isSaveAttributes() && exportData.getAttributes() != null) {
            if (exportData.getAttributes().values().stream().anyMatch(d -> !d.isEmpty())) {
                importResult.setUpdatedRelatedEntities(true);
            }
            this.importAttributes(ctx.getUser(), exportData.getAttributes(), importResult);
        }
    }

    private void importRelations(EntitiesImportCtx ctx, List<EntityRelation> relations, EntityImportResult<E> importResult, IdProvider idProvider) {
        TenantId tenantId = ctx.getTenantId();
        ExportableEntity entity = importResult.getSavedEntity();
        importResult.addSaveReferencesCallback(() -> {
            for (EntityRelation relation : relations) {
                if (!relation.getTo().equals(entity.getId())) {
                    relation.setTo(idProvider.getInternalId(relation.getTo()));
                }
                if (relation.getFrom().equals(entity.getId())) continue;
                relation.setFrom(idProvider.getInternalId(relation.getFrom()));
            }
            LinkedHashMap relationsMap = new LinkedHashMap();
            relations.forEach(r -> relationsMap.put(r, r));
            if (importResult.getOldEntity() != null) {
                ArrayList existingRelations = new ArrayList();
                existingRelations.addAll(this.relationDao.findAllByTo(tenantId, (EntityId)entity.getId(), RelationTypeGroup.COMMON));
                existingRelations.addAll(this.relationDao.findAllByFrom(tenantId, (EntityId)entity.getId(), RelationTypeGroup.COMMON));
                for (EntityRelation existingRelation : existingRelations) {
                    EntityRelation relation = (EntityRelation)relationsMap.get(existingRelation);
                    if (relation == null) {
                        importResult.setUpdatedRelatedEntities(true);
                        this.relationService.deleteRelation(ctx.getTenantId(), existingRelation.getFrom(), existingRelation.getTo(), existingRelation.getType(), existingRelation.getTypeGroup());
                        importResult.addSendEventsCallback(() -> this.logEntityActionService.logEntityRelationAction(tenantId, null, existingRelation, ctx.getUser(), ActionType.RELATION_DELETED, null, existingRelation));
                        continue;
                    }
                    if (!Objects.equal((Object)relation.getAdditionalInfo(), (Object)existingRelation.getAdditionalInfo())) continue;
                    relationsMap.remove(relation);
                }
            }
            if (!relationsMap.isEmpty()) {
                importResult.setUpdatedRelatedEntities(true);
                ctx.addRelations(relationsMap.values());
            }
        });
    }

    private void importAttributes(User user, Map<String, List<AttributeExportData>> attributes, EntityImportResult<E> importResult) {
        final ExportableEntity entity = importResult.getSavedEntity();
        importResult.addSaveReferencesCallback(() -> attributes.forEach((scope, attributesExportData) -> {
            List attributeKvEntries = attributesExportData.stream().map(attributeExportData -> {
                StringDataEntry kvEntry;
                String key = attributeExportData.getKey();
                if (attributeExportData.getStrValue() != null) {
                    kvEntry = new StringDataEntry(key, attributeExportData.getStrValue());
                } else if (attributeExportData.getBooleanValue() != null) {
                    kvEntry = new BooleanDataEntry(key, attributeExportData.getBooleanValue());
                } else if (attributeExportData.getDoubleValue() != null) {
                    kvEntry = new DoubleDataEntry(key, attributeExportData.getDoubleValue());
                } else if (attributeExportData.getLongValue() != null) {
                    kvEntry = new LongDataEntry(key, attributeExportData.getLongValue());
                } else if (attributeExportData.getJsonValue() != null) {
                    kvEntry = new JsonDataEntry(key, attributeExportData.getJsonValue());
                } else {
                    throw new IllegalArgumentException("Invalid attribute export data");
                }
                return new BaseAttributeKvEntry((KvEntry)kvEntry, attributeExportData.getLastUpdateTs().longValue());
            }).collect(Collectors.toList());
            this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(user.getTenantId()).entityId((EntityId)entity.getId()).scope(scope).entries(attributeKvEntries).callback((FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void unused) {
                }

                public void onFailure(Throwable thr) {
                    log.error("Failed to import attributes for {} {}", new Object[]{((EntityId)entity.getId()).getEntityType(), entity.getId(), thr});
                }
            }).build());
        }));
    }

    protected boolean importCalculatedFields(EntitiesImportCtx ctx, E savedEntity, D exportData, IdProvider idProvider) {
        boolean found;
        if (exportData.getCalculatedFields() == null || !ctx.isSaveCalculatedFields()) {
            return false;
        }
        boolean updated = false;
        List existing = this.calculatedFieldService.findCalculatedFieldsByEntityId(ctx.getTenantId(), (EntityId)savedEntity.getId());
        List<CalculatedField> fieldsToSave = exportData.getCalculatedFields().stream().peek(calculatedField -> {
            calculatedField.setTenantId(ctx.getTenantId());
            calculatedField.setEntityId((EntityId)savedEntity.getId());
            calculatedField.getConfiguration().getArguments().values().forEach(argument -> {
                if (argument.getRefEntityId() != null) {
                    argument.setRefEntityId(idProvider.getInternalId(argument.getRefEntityId(), ctx.isFinalImportAttempt()));
                }
            });
        }).toList();
        for (CalculatedField existingField2 : existing) {
            found = fieldsToSave.stream().anyMatch(importedField -> this.compareCalculatedFields(existingField2, (CalculatedField)importedField));
            if (found) continue;
            this.calculatedFieldService.deleteCalculatedField(ctx.getTenantId(), existingField2.getId());
            updated = true;
        }
        for (CalculatedField calculatedField2 : fieldsToSave) {
            found = existing.stream().anyMatch(existingField -> this.compareCalculatedFields((CalculatedField)existingField, calculatedField2));
            if (found) continue;
            this.calculatedFieldService.save(calculatedField2);
            updated = true;
        }
        return updated;
    }

    private boolean compareCalculatedFields(CalculatedField existingField, CalculatedField newField) {
        CalculatedField oldCopy = new CalculatedField(existingField);
        CalculatedField newCopy = new CalculatedField(newField);
        oldCopy.setId(null);
        newCopy.setId(null);
        oldCopy.setVersion(null);
        newCopy.setVersion(null);
        oldCopy.setCreatedTime(0L);
        newCopy.setCreatedTime(0L);
        return oldCopy.equals((Object)newCopy);
    }

    protected void onEntitySaved(User user, E savedEntity, E oldEntity) throws ThingsboardException {
        this.logEntityActionService.logEntityAction(user.getTenantId(), (EntityId)savedEntity.getId(), savedEntity, (CustomerId)null, oldEntity == null ? ActionType.ADDED : ActionType.UPDATED, user, new Object[0]);
    }

    protected E findExistingEntity(EntitiesImportCtx ctx, E entity, IdProvider idProvider) {
        return (E)((ExportableEntity)Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndExternalId(ctx.getTenantId(), (EntityId)entity.getId())).or(() -> Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndId(ctx.getTenantId(), (EntityId)entity.getId()))).or(() -> {
            if (ctx.isFindExistingByName()) {
                return Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndName(ctx.getTenantId(), this.getEntityType(), entity.getName()));
            }
            return Optional.empty();
        }).or(() -> {
            HasDefaultOption hasDefaultOption;
            if (entity instanceof HasDefaultOption && (hasDefaultOption = (HasDefaultOption)entity).isDefault()) {
                return Optional.ofNullable(this.entitiesService.findDefaultEntityByTenantId(ctx.getTenantId(), this.getEntityType()));
            }
            return Optional.empty();
        }).orElse(null));
    }

    private <ID extends EntityId> HasId<ID> findInternalEntity(TenantId tenantId, ID externalId) {
        return (HasId)Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndExternalId(tenantId, externalId)).or(() -> Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndId(tenantId, externalId))).orElseThrow(() -> new MissingEntityException(externalId));
    }

    protected void replaceIdsRecursively(EntitiesImportCtx ctx, IdProvider idProvider, JsonNode json, Set<String> skippedRootFields, Pattern includedFieldsPattern, LinkedHashSet<EntityType> hints) {
        JacksonUtil.replaceUuidsRecursively((JsonNode)json, skippedRootFields, (Pattern)includedFieldsPattern, uuid -> idProvider.getInternalIdByUuid((UUID)uuid, ctx.isFinalImportAttempt(), (Set<EntityType>)hints).map(EntityId::getId).orElse((UUID)uuid), (boolean)true);
    }

    protected class IdProvider {
        private final EntitiesImportCtx ctx;
        private final EntityImportResult<E> importResult;

        public <ID extends EntityId> ID getInternalId(ID externalId) {
            return this.getInternalId(externalId, true);
        }

        public <ID extends EntityId> ID getInternalId(ID externalId, boolean throwExceptionIfNotFound) {
            HasId<ID> entity;
            if (externalId == null || externalId.isNullUid()) {
                return null;
            }
            if (EntityType.TENANT.equals((Object)externalId.getEntityType())) {
                return (ID)this.ctx.getTenantId();
            }
            EntityId localId = this.ctx.getInternalId(externalId);
            if (localId != null) {
                return (ID)localId;
            }
            try {
                entity = BaseEntityImportService.this.findInternalEntity(this.ctx.getTenantId(), externalId);
            }
            catch (Exception e) {
                if (throwExceptionIfNotFound) {
                    throw e;
                }
                this.importResult.setUpdatedAllExternalIds(false);
                return null;
            }
            this.ctx.putInternalId(externalId, (EntityId)entity.getId());
            return (ID)((EntityId)entity.getId());
        }

        public Optional<EntityId> getInternalIdByUuid(UUID externalUuid, boolean fetchAllUUIDs, Set<EntityType> hints) {
            EntityId internalId;
            if (externalUuid.equals(EntityId.NULL_UUID)) {
                return Optional.empty();
            }
            for (EntityType entityType : EntityType.values()) {
                Optional<EntityId> externalId = this.buildEntityId(entityType, externalUuid);
                if (externalId.isEmpty() || (internalId = this.ctx.getInternalId(externalId.get())) == null) continue;
                return Optional.of(internalId);
            }
            if (fetchAllUUIDs) {
                Set<EntityType> processLast = Set.of(EntityType.TENANT);
                ArrayList<EntityType> entityTypes = new ArrayList<EntityType>(hints);
                for (EntityType entityType : EntityType.values()) {
                    if (hints.contains(entityType) || processLast.contains(entityType)) continue;
                    entityTypes.add(entityType);
                }
                entityTypes.addAll(processLast);
                for (EntityType entityType : entityTypes) {
                    Optional<EntityId> externalId = this.buildEntityId(entityType, externalUuid);
                    if (externalId.isEmpty() || this.ctx.isNotFound(externalId.get())) continue;
                    internalId = this.getInternalId(externalId.get(), false);
                    if (internalId != null) {
                        return Optional.of(internalId);
                    }
                    this.ctx.registerNotFound(externalId.get());
                }
            }
            this.importResult.setUpdatedAllExternalIds(false);
            return Optional.empty();
        }

        private Optional<EntityId> buildEntityId(EntityType entityType, UUID externalUuid) {
            try {
                return Optional.of(EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)externalUuid));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }

        @ConstructorProperties(value={"ctx", "importResult"})
        @Generated
        public IdProvider(EntitiesImportCtx ctx, EntityImportResult<E> importResult) {
            this.ctx = ctx;
            this.importResult = importResult;
        }
    }

    static class CompareResult {
        private boolean updateNeeded;
        private boolean externalIdChangedOnly;

        public CompareResult(boolean updateNeeded) {
            this.updateNeeded = updateNeeded;
        }

        @Generated
        public boolean isUpdateNeeded() {
            return this.updateNeeded;
        }

        @Generated
        public boolean isExternalIdChangedOnly() {
            return this.externalIdChangedOnly;
        }

        @Generated
        public void setUpdateNeeded(boolean updateNeeded) {
            this.updateNeeded = updateNeeded;
        }

        @Generated
        public void setExternalIdChangedOnly(boolean externalIdChangedOnly) {
            this.externalIdChangedOnly = externalIdChangedOnly;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompareResult)) {
                return false;
            }
            CompareResult other = (CompareResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUpdateNeeded() != other.isUpdateNeeded()) {
                return false;
            }
            return this.isExternalIdChangedOnly() == other.isExternalIdChangedOnly();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CompareResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUpdateNeeded() ? 79 : 97);
            result = result * 59 + (this.isExternalIdChangedOnly() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "BaseEntityImportService.CompareResult(updateNeeded=" + this.isUpdateNeeded() + ", externalIdChangedOnly=" + this.isExternalIdChangedOnly() + ")";
        }

        @ConstructorProperties(value={"updateNeeded", "externalIdChangedOnly"})
        @Generated
        public CompareResult(boolean updateNeeded, boolean externalIdChangedOnly) {
            this.updateNeeded = updateNeeded;
            this.externalIdChangedOnly = externalIdChangedOnly;
        }
    }
}

