/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import java.beans.ConstructorProperties;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.sync.ie.DeviceExportData;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.impl.BaseEntityExportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
public class DeviceExportService
extends BaseEntityExportService<DeviceId, Device, DeviceExportData> {
    private final DeviceCredentialsService deviceCredentialsService;

    @Override
    protected void setRelatedEntities(EntitiesExportCtx<?> ctx, Device device, DeviceExportData exportData) {
        device.setCustomerId(this.getExternalIdOrElseInternal(ctx, device.getCustomerId()));
        device.setDeviceProfileId(this.getExternalIdOrElseInternal(ctx, device.getDeviceProfileId()));
        device.setFirmwareId(this.getExternalIdOrElseInternal(ctx, device.getFirmwareId()));
        device.setSoftwareId(this.getExternalIdOrElseInternal(ctx, device.getSoftwareId()));
        if (ctx.getSettings().isExportCredentials()) {
            DeviceCredentials credentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(ctx.getTenantId(), device.getId());
            credentials.setId(null);
            credentials.setDeviceId(null);
            exportData.setCredentials(credentials);
        }
    }

    @Override
    protected DeviceExportData newExportData() {
        return new DeviceExportData();
    }

    @Override
    public Set<EntityType> getSupportedEntityTypes() {
        return Set.of(EntityType.DEVICE);
    }

    @ConstructorProperties(value={"deviceCredentialsService"})
    @Generated
    public DeviceExportService(DeviceCredentialsService deviceCredentialsService) {
        this.deviceCredentialsService = deviceCredentialsService;
    }
}

