/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.subscription.TbSubscriptionType;

public abstract class TbSubscription<T> {
    private transient int hash;
    private final String serviceId;
    private final String sessionId;
    private final int subscriptionId;
    private final TenantId tenantId;
    private final EntityId entityId;
    private final TbSubscriptionType type;
    private final BiConsumer<TbSubscription<T>, T> updateProcessor;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TbSubscription that = (TbSubscription)o;
        return this.subscriptionId == that.subscriptionId && this.sessionId.equals(that.sessionId) && this.tenantId.equals((Object)that.tenantId) && this.entityId.equals(that.entityId) && this.type == that.type;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(new Object[]{this.sessionId, this.subscriptionId, this.tenantId, this.entityId, this.type});
        }
        return this.hash;
    }

    @ConstructorProperties(value={"serviceId", "sessionId", "subscriptionId", "tenantId", "entityId", "type", "updateProcessor"})
    @Generated
    public TbSubscription(String serviceId, String sessionId, int subscriptionId, TenantId tenantId, EntityId entityId, TbSubscriptionType type, BiConsumer<TbSubscription<T>, T> updateProcessor) {
        this.serviceId = serviceId;
        this.sessionId = sessionId;
        this.subscriptionId = subscriptionId;
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.type = type;
        this.updateProcessor = updateProcessor;
    }

    @Generated
    public int getHash() {
        return this.hash;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public int getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public TbSubscriptionType getType() {
        return this.type;
    }

    @Generated
    public BiConsumer<TbSubscription<T>, T> getUpdateProcessor() {
        return this.updateProcessor;
    }

    @Generated
    public void setHash(int hash) {
        this.hash = hash;
    }

    @Generated
    public String toString() {
        return "TbSubscription(hash=" + this.getHash() + ", serviceId=" + this.getServiceId() + ", sessionId=" + this.getSessionId() + ", subscriptionId=" + this.getSubscriptionId() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", type=" + String.valueOf((Object)this.getType()) + ", updateProcessor=" + String.valueOf(this.getUpdateProcessor()) + ")";
    }
}

