/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.service.subscription.TbAttributeSubscription;
import org.thingsboard.server.service.subscription.TbEntitySubEvent;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.subscription.TbSubscriptionType;
import org.thingsboard.server.service.subscription.TbSubscriptionsInfo;
import org.thingsboard.server.service.subscription.TbTimeSeriesSubscription;

public class TbEntityLocalSubsInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbEntityLocalSubsInfo.class);
    private final TenantId tenantId;
    private final EntityId entityId;
    private final Set<TbSubscription<?>> subs = ConcurrentHashMap.newKeySet();
    private volatile TbSubscriptionsInfo state = new TbSubscriptionsInfo();
    private final Map<Integer, Set<TbSubscription<?>>> pendingSubs = new ConcurrentHashMap();
    private int pendingTimeSeriesEvent;
    private long pendingTimeSeriesEventTs;
    private int pendingAttributesEvent;
    private long pendingAttributesEventTs;
    private int seqNumber = 0;

    public TbEntitySubEvent add(TbSubscription<?> subscription) {
        log.trace("[{}][{}][{}] Adding: {}", new Object[]{this.tenantId, this.entityId, subscription.getSubscriptionId(), subscription});
        boolean created = this.subs.isEmpty();
        this.subs.add(subscription);
        TbSubscriptionsInfo newState = created ? this.state : this.state.copy();
        boolean stateChanged = false;
        switch (subscription.getType()) {
            case NOTIFICATIONS: 
            case NOTIFICATIONS_COUNT: {
                if (newState.notifications) break;
                newState.notifications = true;
                stateChanged = true;
                break;
            }
            case ALARMS: {
                if (newState.alarms) break;
                newState.alarms = true;
                stateChanged = true;
                break;
            }
            case ATTRIBUTES: {
                TbAttributeSubscription attrSub = (TbAttributeSubscription)subscription;
                if (newState.attrAllKeys) break;
                if (attrSub.isAllKeys()) {
                    newState.attrAllKeys = true;
                    stateChanged = true;
                    break;
                }
                if (newState.attrKeys == null) {
                    newState.attrKeys = new HashSet<String>(attrSub.getKeyStates().keySet());
                    stateChanged = true;
                    break;
                }
                if (!newState.attrKeys.addAll(attrSub.getKeyStates().keySet())) break;
                stateChanged = true;
                break;
            }
            case TIMESERIES: {
                TbTimeSeriesSubscription tsSub = (TbTimeSeriesSubscription)subscription;
                if (newState.tsAllKeys) break;
                if (tsSub.isAllKeys()) {
                    newState.tsAllKeys = true;
                    stateChanged = true;
                    break;
                }
                if (newState.tsKeys == null) {
                    newState.tsKeys = new HashSet<String>(tsSub.getKeyStates().keySet());
                    stateChanged = true;
                    break;
                }
                if (!newState.tsKeys.addAll(tsSub.getKeyStates().keySet())) break;
                stateChanged = true;
            }
        }
        if (stateChanged) {
            this.state = newState;
        }
        if (created) {
            return this.toEvent(ComponentLifecycleEvent.CREATED);
        }
        if (stateChanged) {
            return this.toEvent(ComponentLifecycleEvent.UPDATED);
        }
        return null;
    }

    public TbEntitySubEvent remove(TbSubscription<?> sub) {
        log.trace("[{}][{}][{}] Removing: {}", new Object[]{this.tenantId, this.entityId, sub.getSubscriptionId(), sub});
        if (!this.subs.remove(sub)) {
            return null;
        }
        if (this.isEmpty()) {
            return this.toEvent(ComponentLifecycleEvent.DELETED);
        }
        TbSubscriptionType type = sub.getType();
        TbSubscriptionsInfo newState = this.state.copy();
        this.clearState(newState, type);
        return this.updateState(Set.of(type), newState);
    }

    public TbEntitySubEvent removeAll(List<? extends TbSubscription<?>> subsToRemove) {
        HashSet<TbSubscriptionType> changedTypes = new HashSet<TbSubscriptionType>();
        TbSubscriptionsInfo newState = this.state.copy();
        for (TbSubscription<?> sub : subsToRemove) {
            log.trace("[{}][{}][{}] Removing: {}", new Object[]{this.tenantId, this.entityId, sub.getSubscriptionId(), sub});
            if (!this.subs.remove(sub)) continue;
            if (this.isEmpty()) {
                return this.toEvent(ComponentLifecycleEvent.DELETED);
            }
            TbSubscriptionType type = sub.getType();
            if (changedTypes.contains((Object)type)) continue;
            this.clearState(newState, type);
            changedTypes.add(type);
        }
        return this.updateState(changedTypes, newState);
    }

    private void clearState(TbSubscriptionsInfo state, TbSubscriptionType type) {
        switch (type) {
            case NOTIFICATIONS: 
            case NOTIFICATIONS_COUNT: {
                state.notifications = false;
                break;
            }
            case ALARMS: {
                state.alarms = false;
                break;
            }
            case ATTRIBUTES: {
                state.attrAllKeys = false;
                state.attrKeys = null;
                break;
            }
            case TIMESERIES: {
                state.tsAllKeys = false;
                state.tsKeys = null;
            }
        }
    }

    private TbEntitySubEvent updateState(Set<TbSubscriptionType> updatedTypes, TbSubscriptionsInfo newState) {
        for (TbSubscription<?> subscription : this.subs) {
            TbSubscriptionType type = subscription.getType();
            if (!updatedTypes.contains((Object)type)) continue;
            switch (type) {
                case NOTIFICATIONS: 
                case NOTIFICATIONS_COUNT: {
                    if (newState.notifications) break;
                    newState.notifications = true;
                    break;
                }
                case ALARMS: {
                    if (newState.alarms) break;
                    newState.alarms = true;
                    break;
                }
                case ATTRIBUTES: {
                    TbAttributeSubscription attrSub = (TbAttributeSubscription)subscription;
                    if (!newState.attrAllKeys && attrSub.isAllKeys()) {
                        newState.attrAllKeys = true;
                        break;
                    }
                    if (newState.attrKeys == null) {
                        newState.attrKeys = new HashSet<String>(attrSub.getKeyStates().keySet());
                        break;
                    }
                    newState.attrKeys.addAll(attrSub.getKeyStates().keySet());
                    break;
                }
                case TIMESERIES: {
                    TbTimeSeriesSubscription tsSub = (TbTimeSeriesSubscription)subscription;
                    if (!newState.tsAllKeys && tsSub.isAllKeys()) {
                        newState.tsAllKeys = true;
                        break;
                    }
                    if (newState.tsKeys == null) {
                        newState.tsKeys = new HashSet<String>(tsSub.getKeyStates().keySet());
                        break;
                    }
                    newState.tsKeys.addAll(tsSub.getKeyStates().keySet());
                }
            }
        }
        if (newState.equals(this.state)) {
            return null;
        }
        this.state = newState;
        return this.toEvent(ComponentLifecycleEvent.UPDATED);
    }

    public TbEntitySubEvent toEvent(ComponentLifecycleEvent type) {
        ++this.seqNumber;
        TbEntitySubEvent.TbEntitySubEventBuilder result = TbEntitySubEvent.builder().tenantId(this.tenantId).entityId(this.entityId).type(type).seqNumber(this.seqNumber);
        if (!ComponentLifecycleEvent.DELETED.equals((Object)type)) {
            result.info(this.state.copy(this.seqNumber));
        }
        return result.build();
    }

    public boolean isNf() {
        return this.state.notifications;
    }

    public boolean isEmpty() {
        return this.subs.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TbSubscription<?> registerPendingSubscription(TbSubscription<?> subscription, TbEntitySubEvent event) {
        if (TbSubscriptionType.ATTRIBUTES.equals((Object)subscription.getType())) {
            if (event != null) {
                log.trace("[{}][{}] Registering new pending attributes subscription event: {} for subscription: {}", new Object[]{this.tenantId, this.entityId, event.getSeqNumber(), subscription.getSubscriptionId()});
                this.pendingAttributesEvent = event.getSeqNumber();
                this.pendingAttributesEventTs = System.currentTimeMillis();
                this.pendingSubs.computeIfAbsent(this.pendingAttributesEvent, e -> new HashSet()).add(subscription);
                return null;
            } else {
                if (this.pendingAttributesEvent <= 0) return subscription;
                log.trace("[{}][{}] Registering pending attributes subscription {} for event: {} ", new Object[]{this.tenantId, this.entityId, subscription.getSubscriptionId(), this.pendingAttributesEvent});
                this.pendingSubs.computeIfAbsent(this.pendingAttributesEvent, e -> new HashSet()).add(subscription);
            }
            return null;
        } else {
            if (!(subscription instanceof TbTimeSeriesSubscription)) return null;
            if (event != null) {
                log.trace("[{}][{}] Registering new pending time-series subscription event: {} for subscription: {}", new Object[]{this.tenantId, this.entityId, event.getSeqNumber(), subscription.getSubscriptionId()});
                this.pendingTimeSeriesEvent = event.getSeqNumber();
                this.pendingTimeSeriesEventTs = System.currentTimeMillis();
                this.pendingSubs.computeIfAbsent(this.pendingTimeSeriesEvent, e -> new HashSet()).add(subscription);
                return null;
            } else {
                if (this.pendingTimeSeriesEvent <= 0) return subscription;
                log.trace("[{}][{}] Registering pending time-series subscription {} for event: {} ", new Object[]{this.tenantId, this.entityId, subscription.getSubscriptionId(), this.pendingTimeSeriesEvent});
                this.pendingSubs.computeIfAbsent(this.pendingTimeSeriesEvent, e -> new HashSet()).add(subscription);
            }
        }
        return null;
    }

    public Set<TbSubscription<?>> clearPendingSubscriptions(int seqNumber) {
        if (this.pendingTimeSeriesEvent == seqNumber) {
            this.pendingTimeSeriesEvent = 0;
            this.pendingTimeSeriesEventTs = 0L;
        } else if (this.pendingAttributesEvent == seqNumber) {
            this.pendingAttributesEvent = 0;
            this.pendingAttributesEventTs = 0L;
        }
        return this.pendingSubs.remove(seqNumber);
    }

    @ConstructorProperties(value={"tenantId", "entityId"})
    @Generated
    public TbEntityLocalSubsInfo(TenantId tenantId, EntityId entityId) {
        this.tenantId = tenantId;
        this.entityId = entityId;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public Set<TbSubscription<?>> getSubs() {
        return this.subs;
    }

    @Generated
    public int getPendingTimeSeriesEvent() {
        return this.pendingTimeSeriesEvent;
    }

    @Generated
    public void setPendingTimeSeriesEvent(int pendingTimeSeriesEvent) {
        this.pendingTimeSeriesEvent = pendingTimeSeriesEvent;
    }

    @Generated
    public long getPendingTimeSeriesEventTs() {
        return this.pendingTimeSeriesEventTs;
    }

    @Generated
    public void setPendingTimeSeriesEventTs(long pendingTimeSeriesEventTs) {
        this.pendingTimeSeriesEventTs = pendingTimeSeriesEventTs;
    }

    @Generated
    public int getPendingAttributesEvent() {
        return this.pendingAttributesEvent;
    }

    @Generated
    public void setPendingAttributesEvent(int pendingAttributesEvent) {
        this.pendingAttributesEvent = pendingAttributesEvent;
    }

    @Generated
    public long getPendingAttributesEventTs() {
        return this.pendingAttributesEventTs;
    }

    @Generated
    public void setPendingAttributesEventTs(long pendingAttributesEventTs) {
        this.pendingAttributesEventTs = pendingAttributesEventTs;
    }
}

