/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.query.OriginatorAlarmFilter;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.subscription.SubscriptionServiceStatistics;
import org.thingsboard.server.service.subscription.TbAbstractSubCtx;
import org.thingsboard.server.service.subscription.TbAlarmStatusSubscription;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.AlarmStatusCmd;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.AlarmStatusUpdate;
import org.thingsboard.server.service.ws.telemetry.sub.AlarmSubscriptionUpdate;

public class TbAlarmStatusSubCtx
extends TbAbstractSubCtx {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbAlarmStatusSubCtx.class);
    private final AlarmService alarmService;
    private final int alarmsPerAlarmStatusSubscriptionCacheSize;
    private volatile TbAlarmStatusSubscription subscription;

    public TbAlarmStatusSubCtx(String serviceId, WebSocketService wsService, TbLocalSubscriptionService localSubscriptionService, SubscriptionServiceStatistics stats, AlarmService alarmService, int alarmsPerAlarmStatusSubscriptionCacheSize, WebSocketSessionRef sessionRef, int cmdId) {
        super(serviceId, wsService, localSubscriptionService, stats, sessionRef, cmdId);
        this.alarmService = alarmService;
        this.alarmsPerAlarmStatusSubscriptionCacheSize = alarmsPerAlarmStatusSubscriptionCacheSize;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        this.localSubscriptionService.cancelSubscription(this.getTenantId(), this.sessionRef.getSessionId(), this.subscription.getSubscriptionId());
    }

    public void createSubscription(AlarmStatusCmd cmd) {
        SecurityUser securityCtx = this.sessionRef.getSecurityCtx();
        this.subscription = TbAlarmStatusSubscription.builder().serviceId(this.serviceId).sessionId(this.sessionRef.getSessionId()).subscriptionId(this.sessionRef.getSessionSubIdSeq().incrementAndGet()).tenantId(securityCtx.getTenantId()).entityId(cmd.getOriginatorId()).typeList(cmd.getTypeList()).severityList(cmd.getSeverityList()).updateProcessor(this::handleAlarmStatusSubscriptionUpdate).build();
        this.localSubscriptionService.addSubscription(this.subscription, this.sessionRef);
    }

    public void sendUpdate() {
        this.sendWsMsg(AlarmStatusUpdate.builder().cmdId(this.cmdId).active(this.subscription.hasAlarms()).build());
    }

    public void fetchActiveAlarms() {
        log.trace("[{}, subId: {}] Fetching active alarms from DB", (Object)this.subscription.getSessionId(), (Object)this.subscription.getSubscriptionId());
        OriginatorAlarmFilter originatorAlarmFilter = new OriginatorAlarmFilter(this.subscription.getEntityId(), this.subscription.getTypeList(), this.subscription.getSeverityList());
        List alarmIds = this.alarmService.findActiveOriginatorAlarms(this.subscription.getTenantId(), originatorAlarmFilter, this.alarmsPerAlarmStatusSubscriptionCacheSize);
        this.subscription.getAlarmIds().addAll(alarmIds);
        this.subscription.setHasMoreAlarmsInDB(alarmIds.size() == this.alarmsPerAlarmStatusSubscriptionCacheSize);
    }

    private void handleAlarmStatusSubscriptionUpdate(TbSubscription<AlarmSubscriptionUpdate> sub, AlarmSubscriptionUpdate subscriptionUpdate) {
        block11: {
            try {
                AlarmInfo alarm = subscriptionUpdate.getAlarm();
                Set<UUID> alarmsIds = this.subscription.getAlarmIds();
                if (alarmsIds.contains(alarm.getId().getId())) {
                    if (this.subscription.matches(alarm) && !subscriptionUpdate.isAlarmDeleted()) break block11;
                    alarmsIds.remove(alarm.getId().getId());
                    if (!alarmsIds.isEmpty()) break block11;
                    if (this.subscription.isHasMoreAlarmsInDB()) {
                        this.fetchActiveAlarms();
                        if (alarmsIds.isEmpty()) {
                            this.sendUpdate();
                        }
                    } else {
                        this.sendUpdate();
                    }
                    break block11;
                }
                if (this.subscription.matches(alarm)) {
                    if (alarmsIds.size() < this.alarmsPerAlarmStatusSubscriptionCacheSize) {
                        alarmsIds.add(alarm.getId().getId());
                        if (alarmsIds.size() == 1) {
                            this.sendUpdate();
                        }
                    } else {
                        this.subscription.setHasMoreAlarmsInDB(true);
                    }
                }
            }
            catch (Exception e) {
                log.error("[{}, subId: {}] Failed to handle update for alarm status subscription: {}", new Object[]{this.subscription.getSessionId(), this.subscription.getSubscriptionId(), subscriptionUpdate, e});
            }
        }
    }

    @Override
    @Generated
    public String toString() {
        return "TbAlarmStatusSubCtx(super=" + super.toString() + ", alarmService=" + String.valueOf(this.alarmService) + ", alarmsPerAlarmStatusSubscriptionCacheSize=" + this.alarmsPerAlarmStatusSubscriptionCacheSize + ", subscription=" + String.valueOf(this.subscription) + ")";
    }
}

