/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.query.ComplexFilterPredicate;
import org.thingsboard.server.common.data.query.DynamicValue;
import org.thingsboard.server.common.data.query.DynamicValueSourceType;
import org.thingsboard.server.common.data.query.EntityCountQuery;
import org.thingsboard.server.common.data.query.EntityFilter;
import org.thingsboard.server.common.data.query.FilterPredicateType;
import org.thingsboard.server.common.data.query.KeyFilter;
import org.thingsboard.server.common.data.query.KeyFilterPredicate;
import org.thingsboard.server.common.data.query.SimpleKeyFilterPredicate;
import org.thingsboard.server.common.data.query.TsValue;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.service.subscription.SubscriptionServiceStatistics;
import org.thingsboard.server.service.subscription.TbAbstractSubCtx;
import org.thingsboard.server.service.subscription.TbAttributeSubscription;
import org.thingsboard.server.service.subscription.TbAttributeSubscriptionScope;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.telemetry.sub.TelemetrySubscriptionUpdate;

public abstract class TbAbstractEntityQuerySubCtx<T extends EntityCountQuery>
extends TbAbstractSubCtx {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbAbstractEntityQuerySubCtx.class);
    protected final EntityService entityService;
    protected final AttributesService attributesService;
    protected final Set<Integer> subToDynamicValueKeySet;
    protected final Map<DynamicValueKey, List<DynamicValue>> dynamicValues;
    protected T query;
    protected volatile ScheduledFuture<?> refreshTask;

    public TbAbstractEntityQuerySubCtx(String serviceId, WebSocketService wsService, EntityService entityService, TbLocalSubscriptionService localSubscriptionService, AttributesService attributesService, SubscriptionServiceStatistics stats, WebSocketSessionRef sessionRef, int cmdId) {
        super(serviceId, wsService, localSubscriptionService, stats, sessionRef, cmdId);
        this.entityService = entityService;
        this.attributesService = attributesService;
        this.subToDynamicValueKeySet = ConcurrentHashMap.newKeySet();
        this.dynamicValues = new ConcurrentHashMap<DynamicValueKey, List<DynamicValue>>();
    }

    public abstract void fetchData();

    protected abstract void update();

    public void clearSubscriptions() {
        this.clearDynamicValueSubscriptions();
    }

    @Override
    public void stop() {
        super.stop();
        this.cancelTasks();
        this.clearSubscriptions();
    }

    public void setAndResolveQuery(T query) {
        this.dynamicValues.clear();
        this.query = query;
        if (query != null) {
            if (query.getEntityFilter() != null) {
                EntityFilter.resolveEntityFilter((EntityFilter)query.getEntityFilter(), (TenantId)this.getTenantId(), (UserId)this.getUserId(), (EntityId)this.getOwnerId());
            }
            if (query.getKeyFilters() != null) {
                for (KeyFilter filter : query.getKeyFilters()) {
                    this.registerDynamicValues(filter.getPredicate());
                }
            }
        }
        this.resolve(this.getTenantId(), this.getCustomerId(), this.getUserId());
    }

    public void resolve(TenantId tenantId, CustomerId customerId, UserId userId) {
        ArrayList<ListenableFuture<DynamicValueKeySub>> futures = new ArrayList<ListenableFuture<DynamicValueKeySub>>();
        for (DynamicValueKey key : this.dynamicValues.keySet()) {
            switch (key.getSourceType()) {
                case CURRENT_TENANT: {
                    futures.add(this.resolveEntityValue(tenantId, (EntityId)tenantId, key));
                    break;
                }
                case CURRENT_CUSTOMER: {
                    if (customerId == null || customerId.isNullUid()) break;
                    futures.add(this.resolveEntityValue(tenantId, (EntityId)customerId, key));
                    break;
                }
                case CURRENT_USER: {
                    if (userId == null || userId.isNullUid()) break;
                    futures.add(this.resolveEntityValue(tenantId, (EntityId)userId, key));
                }
            }
        }
        try {
            HashMap<EntityId, Map> tmpSubMap = new HashMap<EntityId, Map>();
            for (DynamicValueKeySub sub : (List)Futures.successfulAsList(futures).get()) {
                tmpSubMap.computeIfAbsent(sub.getEntityId(), tmp -> new HashMap()).put(sub.getKey().getSourceAttribute(), sub);
            }
            for (EntityId entityId : tmpSubMap.keySet()) {
                HashMap<String, Long> keyStates = new HashMap<String, Long>();
                Map dynamicValueKeySubMap = (Map)tmpSubMap.get(entityId);
                dynamicValueKeySubMap.forEach((k, v) -> keyStates.put((String)k, v.getLastUpdateTs()));
                int subIdx = this.sessionRef.getSessionSubIdSeq().incrementAndGet();
                TbAttributeSubscription sub = TbAttributeSubscription.builder().serviceId(this.serviceId).sessionId(this.sessionRef.getSessionId()).subscriptionId(subIdx).tenantId(this.sessionRef.getSecurityCtx().getTenantId()).entityId(entityId).updateProcessor((subscription, subscriptionUpdate) -> this.dynamicValueSubUpdate(subscription.getSessionId(), (TelemetrySubscriptionUpdate)subscriptionUpdate, dynamicValueKeySubMap)).queryTs(this.createdTime).allKeys(false).keyStates(keyStates).scope(TbAttributeSubscriptionScope.SERVER_SCOPE).build();
                this.subToDynamicValueKeySet.add(subIdx);
                this.localSubscriptionService.addSubscription(sub, this.sessionRef);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.info("[{}][{}][{}] Failed to resolve dynamic values: {}", new Object[]{tenantId, customerId, userId, this.dynamicValues.keySet()});
        }
    }

    private void dynamicValueSubUpdate(String sessionId, TelemetrySubscriptionUpdate subscriptionUpdate, Map<String, DynamicValueKeySub> dynamicValueKeySubMap) {
        HashMap latestUpdate = new HashMap();
        subscriptionUpdate.getValues().forEach((key, values) -> latestUpdate.put(key, this.getLatest((List<TsValue>)values)));
        boolean invalidateFilter = false;
        for (Map.Entry entry : latestUpdate.entrySet()) {
            String k = (String)entry.getKey();
            TsValue tsValue = (TsValue)entry.getValue();
            DynamicValueKeySub sub = dynamicValueKeySubMap.get(k);
            if (!sub.updateValue(tsValue)) continue;
            invalidateFilter = true;
            this.updateDynamicValuesByKey(sub, tsValue);
        }
        if (invalidateFilter) {
            this.update();
        }
    }

    private ListenableFuture<DynamicValueKeySub> resolveEntityValue(TenantId tenantId, EntityId entityId, DynamicValueKey key) {
        ListenableFuture entry = this.attributesService.find(tenantId, entityId, AttributeScope.SERVER_SCOPE, key.getSourceAttribute());
        return Futures.transform((ListenableFuture)entry, attributeOpt -> {
            DynamicValueKeySub sub = new DynamicValueKeySub(key, entityId);
            if (attributeOpt.isPresent()) {
                AttributeKvEntry attribute = (AttributeKvEntry)attributeOpt.get();
                sub.setLastUpdateTs(attribute.getLastUpdateTs());
                sub.setLastUpdateValue(attribute.getValueAsString());
                this.updateDynamicValuesByKey(sub, new TsValue(attribute.getLastUpdateTs(), attribute.getValueAsString()));
            }
            return sub;
        }, (Executor)MoreExecutors.directExecutor());
    }

    protected void updateDynamicValuesByKey(DynamicValueKeySub sub, TsValue tsValue) {
        DynamicValueKey dvk = sub.getKey();
        switch (dvk.getPredicateType()) {
            case STRING: {
                this.dynamicValues.get(dvk).forEach(dynamicValue -> dynamicValue.setResolvedValue((Object)tsValue.getValue()));
                break;
            }
            case NUMERIC: {
                try {
                    Double dValue = Double.parseDouble(tsValue.getValue());
                    this.dynamicValues.get(dvk).forEach(dynamicValue -> dynamicValue.setResolvedValue((Object)dValue));
                }
                catch (NumberFormatException e) {
                    this.dynamicValues.get(dvk).forEach(dynamicValue -> dynamicValue.setResolvedValue(null));
                }
                break;
            }
            case BOOLEAN: {
                Boolean bValue = Boolean.parseBoolean(tsValue.getValue());
                this.dynamicValues.get(dvk).forEach(dynamicValue -> dynamicValue.setResolvedValue((Object)bValue));
            }
        }
    }

    private void registerDynamicValues(KeyFilterPredicate predicate) {
        switch (predicate.getType()) {
            case STRING: 
            case NUMERIC: 
            case BOOLEAN: {
                Optional<DynamicValue<T>> value = this.getDynamicValueFromSimplePredicate((SimpleKeyFilterPredicate)predicate);
                if (!value.isPresent()) break;
                DynamicValue<T> dynamicValue = value.get();
                DynamicValueKey key = new DynamicValueKey(predicate.getType(), dynamicValue.getSourceType(), dynamicValue.getSourceAttribute());
                this.dynamicValues.computeIfAbsent(key, tmp -> new ArrayList()).add(dynamicValue);
                break;
            }
            case COMPLEX: {
                ((ComplexFilterPredicate)predicate).getPredicates().forEach(this::registerDynamicValues);
            }
        }
    }

    private Optional<DynamicValue<T>> getDynamicValueFromSimplePredicate(SimpleKeyFilterPredicate<T> predicate) {
        if (predicate.getValue().getUserValue() == null) {
            return Optional.ofNullable(predicate.getValue().getDynamicValue());
        }
        return Optional.empty();
    }

    protected void clearDynamicValueSubscriptions() {
        if (this.subToDynamicValueKeySet != null) {
            for (Integer subId : this.subToDynamicValueKeySet) {
                this.localSubscriptionService.cancelSubscription(this.getTenantId(), this.sessionRef.getSessionId(), subId);
            }
            this.subToDynamicValueKeySet.clear();
        }
    }

    public void setRefreshTask(ScheduledFuture<?> task) {
        if (!this.stopped) {
            this.refreshTask = task;
        } else {
            task.cancel(true);
        }
    }

    public void cancelTasks() {
        if (this.refreshTask != null) {
            log.trace("[{}][{}] Canceling old refresh task", (Object)this.sessionRef.getSessionId(), (Object)this.cmdId);
            this.refreshTask.cancel(true);
        }
    }

    protected TsValue getLatest(List<TsValue> values) {
        return values.stream().max(Comparator.comparing(TsValue::getTs)).orElse(null);
    }

    @Generated
    public Map<DynamicValueKey, List<DynamicValue>> getDynamicValues() {
        return this.dynamicValues;
    }

    @Generated
    public T getQuery() {
        return this.query;
    }

    @Generated
    public void setQuery(T query) {
        this.query = query;
    }

    public static class DynamicValueKey {
        private final FilterPredicateType predicateType;
        private final DynamicValueSourceType sourceType;
        private final String sourceAttribute;

        @ConstructorProperties(value={"predicateType", "sourceType", "sourceAttribute"})
        @Generated
        public DynamicValueKey(FilterPredicateType predicateType, DynamicValueSourceType sourceType, String sourceAttribute) {
            this.predicateType = predicateType;
            this.sourceType = sourceType;
            this.sourceAttribute = sourceAttribute;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DynamicValueKey)) {
                return false;
            }
            DynamicValueKey other = (DynamicValueKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FilterPredicateType this$predicateType = this.getPredicateType();
            FilterPredicateType other$predicateType = other.getPredicateType();
            if (this$predicateType == null ? other$predicateType != null : !this$predicateType.equals(other$predicateType)) {
                return false;
            }
            DynamicValueSourceType this$sourceType = this.getSourceType();
            DynamicValueSourceType other$sourceType = other.getSourceType();
            if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
                return false;
            }
            String this$sourceAttribute = this.getSourceAttribute();
            String other$sourceAttribute = other.getSourceAttribute();
            return !(this$sourceAttribute == null ? other$sourceAttribute != null : !this$sourceAttribute.equals(other$sourceAttribute));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DynamicValueKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FilterPredicateType $predicateType = this.getPredicateType();
            result = result * 59 + ($predicateType == null ? 43 : $predicateType.hashCode());
            DynamicValueSourceType $sourceType = this.getSourceType();
            result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
            String $sourceAttribute = this.getSourceAttribute();
            result = result * 59 + ($sourceAttribute == null ? 43 : $sourceAttribute.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TbAbstractEntityQuerySubCtx.DynamicValueKey(predicateType=" + String.valueOf(this.getPredicateType()) + ", sourceType=" + String.valueOf(this.getSourceType()) + ", sourceAttribute=" + this.getSourceAttribute() + ")";
        }

        @Generated
        public FilterPredicateType getPredicateType() {
            return this.predicateType;
        }

        @Generated
        public DynamicValueSourceType getSourceType() {
            return this.sourceType;
        }

        @Generated
        public String getSourceAttribute() {
            return this.sourceAttribute;
        }
    }

    private static class DynamicValueKeySub {
        private final DynamicValueKey key;
        private final EntityId entityId;
        private long lastUpdateTs;
        private String lastUpdateValue;

        boolean updateValue(TsValue value) {
            if (!(value.getTs() <= this.lastUpdateTs || this.lastUpdateValue != null && this.lastUpdateValue.equals(value.getValue()))) {
                this.lastUpdateTs = value.getTs();
                this.lastUpdateValue = value.getValue();
                return true;
            }
            return false;
        }

        @ConstructorProperties(value={"key", "entityId"})
        @Generated
        public DynamicValueKeySub(DynamicValueKey key, EntityId entityId) {
            this.key = key;
            this.entityId = entityId;
        }

        @Generated
        public DynamicValueKey getKey() {
            return this.key;
        }

        @Generated
        public EntityId getEntityId() {
            return this.entityId;
        }

        @Generated
        public long getLastUpdateTs() {
            return this.lastUpdateTs;
        }

        @Generated
        public String getLastUpdateValue() {
            return this.lastUpdateValue;
        }

        @Generated
        public void setLastUpdateTs(long lastUpdateTs) {
            this.lastUpdateTs = lastUpdateTs;
        }

        @Generated
        public void setLastUpdateValue(String lastUpdateValue) {
            this.lastUpdateValue = lastUpdateValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DynamicValueKeySub)) {
                return false;
            }
            DynamicValueKeySub other = (DynamicValueKeySub)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLastUpdateTs() != other.getLastUpdateTs()) {
                return false;
            }
            DynamicValueKey this$key = this.getKey();
            DynamicValueKey other$key = other.getKey();
            if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
                return false;
            }
            EntityId this$entityId = this.getEntityId();
            EntityId other$entityId = other.getEntityId();
            if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
                return false;
            }
            String this$lastUpdateValue = this.getLastUpdateValue();
            String other$lastUpdateValue = other.getLastUpdateValue();
            return !(this$lastUpdateValue == null ? other$lastUpdateValue != null : !this$lastUpdateValue.equals(other$lastUpdateValue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DynamicValueKeySub;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lastUpdateTs = this.getLastUpdateTs();
            result = result * 59 + (int)($lastUpdateTs >>> 32 ^ $lastUpdateTs);
            DynamicValueKey $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            EntityId $entityId = this.getEntityId();
            result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
            String $lastUpdateValue = this.getLastUpdateValue();
            result = result * 59 + ($lastUpdateValue == null ? 43 : $lastUpdateValue.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TbAbstractEntityQuerySubCtx.DynamicValueKeySub(key=" + String.valueOf(this.getKey()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", lastUpdateTs=" + this.getLastUpdateTs() + ", lastUpdateValue=" + this.getLastUpdateValue() + ")";
        }
    }
}

