/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.state;

import org.springframework.context.ApplicationListener;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;

public interface DeviceStateService
extends ApplicationListener<PartitionChangeEvent> {
    public void onDeviceConnect(TenantId var1, DeviceId var2, long var3);

    default public void onDeviceConnect(TenantId tenantId, DeviceId deviceId) {
        this.onDeviceConnect(tenantId, deviceId, System.currentTimeMillis());
    }

    public void onDeviceActivity(TenantId var1, DeviceId var2, long var3);

    public void onDeviceDisconnect(TenantId var1, DeviceId var2, long var3);

    default public void onDeviceDisconnect(TenantId tenantId, DeviceId deviceId) {
        this.onDeviceDisconnect(tenantId, deviceId, System.currentTimeMillis());
    }

    public void onDeviceInactivity(TenantId var1, DeviceId var2, long var3);

    public void onDeviceInactivityTimeoutUpdate(TenantId var1, DeviceId var2, long var3);

    public void onQueueMsg(TransportProtos.DeviceStateServiceMsgProto var1, TbCallback var2);
}

