/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.permission;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.PermissionChecker;
import org.thingsboard.server.service.security.permission.Permissions;
import org.thingsboard.server.service.security.permission.Resource;

@Service
public class DefaultAccessControlService
implements AccessControlService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAccessControlService.class);
    private static final String INCORRECT_TENANT_ID = "Incorrect tenantId ";
    private static final String YOU_DON_T_HAVE_PERMISSION_TO_PERFORM_THIS_OPERATION = "You don't have permission to perform this operation!";
    private final Map<Authority, Permissions> authorityPermissions = new HashMap<Authority, Permissions>();

    public DefaultAccessControlService(@Qualifier(value="sysAdminPermissions") Permissions sysAdminPermissions, @Qualifier(value="tenantAdminPermissions") Permissions tenantAdminPermissions, @Qualifier(value="customerUserPermissions") Permissions customerUserPermissions) {
        this.authorityPermissions.put(Authority.SYS_ADMIN, sysAdminPermissions);
        this.authorityPermissions.put(Authority.TENANT_ADMIN, tenantAdminPermissions);
        this.authorityPermissions.put(Authority.CUSTOMER_USER, customerUserPermissions);
    }

    @Override
    public void checkPermission(SecurityUser user, Resource resource, Operation operation) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), resource);
        if (!permissionChecker.hasPermission(user, operation)) {
            this.permissionDenied();
        }
    }

    @Override
    public <I extends EntityId, T extends HasTenantId> void checkPermission(SecurityUser user, Resource resource, Operation operation, I entityId, T entity) throws ThingsboardException {
        PermissionChecker permissionChecker = this.getPermissionChecker(user.getAuthority(), resource);
        if (!permissionChecker.hasPermission(user, operation, entityId, entity)) {
            this.permissionDenied();
        }
    }

    private PermissionChecker getPermissionChecker(Authority authority, Resource resource) throws ThingsboardException {
        Optional<PermissionChecker> permissionChecker;
        Permissions permissions = this.authorityPermissions.get(authority);
        if (permissions == null) {
            this.permissionDenied();
        }
        if (!(permissionChecker = permissions.getPermissionChecker(resource)).isPresent()) {
            this.permissionDenied();
        }
        return permissionChecker.get();
    }

    private void permissionDenied() throws ThingsboardException {
        throw new ThingsboardException(YOU_DON_T_HAVE_PERMISSION_TO_PERFORM_THIS_OPERATION, ThingsboardErrorCode.PERMISSION_DENIED);
    }
}

