/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.oauth2;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.OAuth2CustomMapperConfig;
import org.thingsboard.server.common.data.oauth2.OAuth2MapperConfig;
import org.thingsboard.server.dao.oauth2.OAuth2User;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.oauth2.AbstractOAuth2ClientMapper;
import org.thingsboard.server.service.security.auth.oauth2.OAuth2ClientMapper;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service(value="customOAuth2ClientMapper")
@TbCoreComponent
public class CustomOAuth2ClientMapper
extends AbstractOAuth2ClientMapper
implements OAuth2ClientMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomOAuth2ClientMapper.class);
    private static final String PROVIDER_ACCESS_TOKEN = "provider-access-token";
    private RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);

    @Override
    public SecurityUser getOrCreateUserByClientPrincipal(HttpServletRequest request, OAuth2AuthenticationToken token, String providerAccessToken, OAuth2Client auth2Client) {
        OAuth2MapperConfig config = auth2Client.getMapperConfig();
        OAuth2User oauth2User = this.getOAuth2User(token, providerAccessToken, config.getCustom());
        return this.getOrCreateSecurityUserFromOAuth2User(oauth2User, auth2Client);
    }

    private synchronized OAuth2User getOAuth2User(OAuth2AuthenticationToken token, String providerAccessToken, OAuth2CustomMapperConfig custom) {
        String request;
        if (!StringUtils.isEmpty((String)custom.getUsername()) && !StringUtils.isEmpty((String)custom.getPassword())) {
            this.restTemplateBuilder = this.restTemplateBuilder.basicAuthentication(custom.getUsername(), custom.getPassword());
        }
        if (custom.isSendToken() && !StringUtils.isEmpty((String)providerAccessToken)) {
            this.restTemplateBuilder = this.restTemplateBuilder.defaultHeader(PROVIDER_ACCESS_TOKEN, new String[]{providerAccessToken});
        }
        RestTemplate restTemplate = this.restTemplateBuilder.build();
        try {
            request = JacksonUtil.getObjectMapperWithJavaTimeModule().writeValueAsString((Object)token.getPrincipal());
        }
        catch (JsonProcessingException e) {
            log.error("Can't convert principal to JSON string", (Throwable)e);
            throw new RuntimeException("Can't convert principal to JSON string", e);
        }
        try {
            return (OAuth2User)restTemplate.postForEntity(custom.getUrl(), (Object)request, OAuth2User.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            log.error("There was an error during connection to custom mapper endpoint", (Throwable)e);
            throw new RuntimeException("Unable to login. Please contact your Administrator!");
        }
    }
}

