/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.oauth2;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.OAuth2MapperConfig;
import org.thingsboard.server.dao.oauth2.OAuth2User;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.oauth2.AbstractOAuth2ClientMapper;
import org.thingsboard.server.service.security.auth.oauth2.BasicMapperUtils;
import org.thingsboard.server.service.security.auth.oauth2.OAuth2ClientMapper;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service(value="basicOAuth2ClientMapper")
@TbCoreComponent
public class BasicOAuth2ClientMapper
extends AbstractOAuth2ClientMapper
implements OAuth2ClientMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicOAuth2ClientMapper.class);

    @Override
    public SecurityUser getOrCreateUserByClientPrincipal(HttpServletRequest request, OAuth2AuthenticationToken token, String providerAccessToken, OAuth2Client oAuth2Client) {
        OAuth2MapperConfig config = oAuth2Client.getMapperConfig();
        Map attributes = token.getPrincipal().getAttributes();
        String email = BasicMapperUtils.getStringAttributeByKey(attributes, config.getBasic().getEmailAttributeKey());
        OAuth2User oauth2User = BasicMapperUtils.getOAuth2User(email, attributes, config);
        return this.getOrCreateSecurityUserFromOAuth2User(oauth2User, oAuth2Client);
    }
}

