/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.jwt.extractor;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.service.security.auth.jwt.extractor.TokenExtractor;

@Component(value="jwtHeaderTokenExtractor")
public class JwtHeaderTokenExtractor
implements TokenExtractor {
    public static final String HEADER_PREFIX = "Bearer ";

    @Override
    public String extract(HttpServletRequest request) {
        String header = request.getHeader("X-Authorization");
        if (StringUtils.isBlank((String)header) && StringUtils.isBlank((String)(header = request.getHeader("Authorization")))) {
            throw new AuthenticationServiceException("Authorization header cannot be blank!");
        }
        if (header.length() < HEADER_PREFIX.length()) {
            throw new AuthenticationServiceException("Invalid authorization header size.");
        }
        return header.substring(HEADER_PREFIX.length(), header.length());
    }
}

