/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ImageDescriptor;
import org.thingsboard.server.common.data.ResourceExportData;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TbImageDeleteResult;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.dao.resource.ImageCacheKey;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.resource.TbImageService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@Service
@TbCoreComponent
public class DefaultTbImageService
extends AbstractTbEntityService
implements TbImageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbImageService.class);
    private final TbClusterService clusterService;
    private final ImageService imageService;
    private final AccessControlService accessControlService;
    private final Cache<ImageCacheKey, String> etagCache;

    public DefaultTbImageService(TbClusterService clusterService, ImageService imageService, AccessControlService accessControlService, @Value(value="${cache.image.etag.timeToLiveInMinutes:44640}") int cacheTtl, @Value(value="${cache.image.etag.maxSize:10000}") int cacheMaxSize) {
        this.clusterService = clusterService;
        this.imageService = imageService;
        this.accessControlService = accessControlService;
        this.etagCache = Caffeine.newBuilder().expireAfterAccess((long)cacheTtl, TimeUnit.MINUTES).maximumSize((long)cacheMaxSize).build();
    }

    @Override
    public String getETag(ImageCacheKey imageCacheKey) {
        return (String)this.etagCache.getIfPresent((Object)imageCacheKey);
    }

    @Override
    public void putETag(ImageCacheKey imageCacheKey, String etag) {
        this.etagCache.put((Object)imageCacheKey, (Object)etag);
    }

    @Override
    public void evictETags(ImageCacheKey imageCacheKey) {
        this.etagCache.invalidate((Object)imageCacheKey);
        if (imageCacheKey.getPublicResourceKey() == null) {
            this.etagCache.invalidate((Object)imageCacheKey.withPreview(true));
        }
    }

    @Override
    public TbResourceInfo save(TbResource image, User user) throws Exception {
        ActionType actionType = image.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = image.getTenantId();
        try {
            Optional<String> newEtag;
            Optional<String> oldEtag = this.getEtag((TbResourceInfo)image);
            TbResourceInfo existingImage = null;
            if (image.getId() == null && StringUtils.isNotEmpty((String)image.getResourceKey()) && (existingImage = this.imageService.getImageInfoByTenantIdAndKey(tenantId, image.getResourceKey())) != null) {
                image.setId((UUIDBased)existingImage.getId());
            }
            TbResourceInfo savedImage = this.imageService.saveImage(image);
            this.logEntityActionService.logEntityAction(tenantId, savedImage.getId(), savedImage, actionType, user, new Object[0]);
            ArrayList<ImageCacheKey> toEvict = new ArrayList<ImageCacheKey>();
            if (oldEtag.isPresent() && (newEtag = this.getEtag(savedImage)).isPresent() && !oldEtag.get().equals(newEtag.get())) {
                toEvict.add(ImageCacheKey.forImage((TenantId)tenantId, (String)image.getResourceKey()));
                if (image.isPublic()) {
                    toEvict.add(ImageCacheKey.forPublicImage((String)savedImage.getPublicResourceKey()));
                }
            }
            if (existingImage != null && image.isPublic() != existingImage.isPublic()) {
                toEvict.add(ImageCacheKey.forPublicImage((String)image.getPublicResourceKey()));
            }
            if (!toEvict.isEmpty()) {
                this.evictFromCache(tenantId, toEvict);
            }
            return savedImage;
        }
        catch (Exception e) {
            image.setData(null);
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.TB_RESOURCE), new TbResourceInfo((TbResourceInfo)image), actionType, user, e, new Object[0]);
            throw e;
        }
    }

    private Optional<String> getEtag(TbResourceInfo image) throws JsonProcessingException {
        ImageDescriptor descriptor = (ImageDescriptor)image.getDescriptor(ImageDescriptor.class);
        return Optional.ofNullable(descriptor != null ? descriptor.getEtag() : null);
    }

    private Optional<String> getPreviewEtag(TbResourceInfo image) throws JsonProcessingException {
        ImageDescriptor descriptor = (ImageDescriptor)image.getDescriptor(ImageDescriptor.class);
        descriptor = descriptor != null ? descriptor.getPreviewDescriptor() : null;
        return Optional.ofNullable(descriptor != null ? descriptor.getEtag() : null);
    }

    @Override
    public TbResourceInfo save(TbResourceInfo imageInfo, TbResourceInfo oldImageInfo, User user) {
        TenantId tenantId = imageInfo.getTenantId();
        TbResourceId imageId = imageInfo.getId();
        try {
            imageInfo = this.imageService.saveImageInfo(imageInfo);
            this.logEntityActionService.logEntityAction(tenantId, imageId, imageInfo, ActionType.UPDATED, user, new Object[0]);
            if (imageInfo.isPublic() != oldImageInfo.isPublic()) {
                this.evictFromCache(tenantId, List.of(ImageCacheKey.forPublicImage((String)imageInfo.getPublicResourceKey())));
            }
            return imageInfo;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, imageId, imageInfo, ActionType.UPDATED, user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public TbImageDeleteResult delete(TbResourceInfo imageInfo, User user, boolean force) {
        TenantId tenantId = imageInfo.getTenantId();
        TbResourceId imageId = imageInfo.getId();
        try {
            TbImageDeleteResult result = this.imageService.deleteImage(imageInfo, force);
            if (result.isSuccess()) {
                this.logEntityActionService.logEntityAction(tenantId, imageId, imageInfo, ActionType.DELETED, user, imageId.toString());
                ArrayList<ImageCacheKey> toEvict = new ArrayList<ImageCacheKey>();
                toEvict.add(ImageCacheKey.forImage((TenantId)tenantId, (String)imageInfo.getResourceKey()));
                if (imageInfo.isPublic()) {
                    toEvict.add(ImageCacheKey.forPublicImage((String)imageInfo.getPublicResourceKey()));
                }
                this.evictFromCache(tenantId, toEvict);
            }
            return result;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, imageId, ActionType.DELETED, user, e, imageId.toString());
            throw e;
        }
    }

    @Override
    public TbResourceInfo importImage(ResourceExportData imageData, boolean checkExisting, SecurityUser user) throws Exception {
        TbResource image = this.imageService.toImage(user.getTenantId(), imageData, checkExisting);
        if (checkExisting && image.getId() != null) {
            this.accessControlService.checkPermission(user, Resource.TB_RESOURCE, Operation.READ, image.getId(), image);
            return image;
        }
        this.accessControlService.checkPermission(user, Resource.TB_RESOURCE, Operation.CREATE, null, image);
        return this.save(image, user);
    }

    private void evictFromCache(TenantId tenantId, List<ImageCacheKey> toEvict) {
        toEvict.forEach(this::evictETags);
        this.clusterService.broadcastToCore(TransportProtos.ToCoreNotificationMsg.newBuilder().setResourceCacheInvalidateMsg(TransportProtos.ResourceCacheInvalidateMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).addAllKeys((Iterable)toEvict.stream().map(ImageCacheKey::toProto).collect(Collectors.toList())).build()).build());
    }
}

