/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue.ruleengine;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.provider.TbRuleEngineQueueFactory;
import org.thingsboard.server.queue.util.TbRuleEngineComponent;
import org.thingsboard.server.service.queue.processing.TbRuleEngineProcessingStrategyFactory;
import org.thingsboard.server.service.queue.processing.TbRuleEngineSubmitStrategyFactory;
import org.thingsboard.server.service.stats.RuleEngineStatisticsService;

@Component
@TbRuleEngineComponent
public class TbRuleEngineConsumerContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbRuleEngineConsumerContext.class);
    @Value(value="${queue.rule-engine.poll-interval}")
    private long pollDuration;
    @Value(value="${queue.rule-engine.pack-processing-timeout}")
    private long packProcessingTimeout;
    @Value(value="${queue.rule-engine.stats.enabled:true}")
    private boolean statsEnabled;
    @Value(value="${queue.rule-engine.prometheus-stats.enabled:false}")
    private boolean prometheusStatsEnabled;
    @Value(value="${queue.rule-engine.topic-deletion-delay:15}")
    private int topicDeletionDelayInSec;
    @Value(value="${queue.rule-engine.management-thread-pool-size:12}")
    private int mgmtThreadPoolSize;
    private final ActorSystemContext actorContext;
    private final StatsFactory statsFactory;
    private final TbRuleEngineSubmitStrategyFactory submitStrategyFactory;
    private final TbRuleEngineProcessingStrategyFactory processingStrategyFactory;
    private final TbRuleEngineQueueFactory queueFactory;
    private final RuleEngineStatisticsService statisticsService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final PartitionService partitionService;
    private final TbQueueProducerProvider producerProvider;
    private final TbQueueAdmin queueAdmin;

    @ConstructorProperties(value={"actorContext", "statsFactory", "submitStrategyFactory", "processingStrategyFactory", "queueFactory", "statisticsService", "serviceInfoProvider", "partitionService", "producerProvider", "queueAdmin"})
    @Generated
    public TbRuleEngineConsumerContext(ActorSystemContext actorContext, StatsFactory statsFactory, TbRuleEngineSubmitStrategyFactory submitStrategyFactory, TbRuleEngineProcessingStrategyFactory processingStrategyFactory, TbRuleEngineQueueFactory queueFactory, RuleEngineStatisticsService statisticsService, TbServiceInfoProvider serviceInfoProvider, PartitionService partitionService, TbQueueProducerProvider producerProvider, TbQueueAdmin queueAdmin) {
        this.actorContext = actorContext;
        this.statsFactory = statsFactory;
        this.submitStrategyFactory = submitStrategyFactory;
        this.processingStrategyFactory = processingStrategyFactory;
        this.queueFactory = queueFactory;
        this.statisticsService = statisticsService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.partitionService = partitionService;
        this.producerProvider = producerProvider;
        this.queueAdmin = queueAdmin;
    }

    @Generated
    public long getPollDuration() {
        return this.pollDuration;
    }

    @Generated
    public long getPackProcessingTimeout() {
        return this.packProcessingTimeout;
    }

    @Generated
    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    @Generated
    public boolean isPrometheusStatsEnabled() {
        return this.prometheusStatsEnabled;
    }

    @Generated
    public int getTopicDeletionDelayInSec() {
        return this.topicDeletionDelayInSec;
    }

    @Generated
    public int getMgmtThreadPoolSize() {
        return this.mgmtThreadPoolSize;
    }

    @Generated
    public ActorSystemContext getActorContext() {
        return this.actorContext;
    }

    @Generated
    public StatsFactory getStatsFactory() {
        return this.statsFactory;
    }

    @Generated
    public TbRuleEngineSubmitStrategyFactory getSubmitStrategyFactory() {
        return this.submitStrategyFactory;
    }

    @Generated
    public TbRuleEngineProcessingStrategyFactory getProcessingStrategyFactory() {
        return this.processingStrategyFactory;
    }

    @Generated
    public TbRuleEngineQueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Generated
    public RuleEngineStatisticsService getStatisticsService() {
        return this.statisticsService;
    }

    @Generated
    public TbServiceInfoProvider getServiceInfoProvider() {
        return this.serviceInfoProvider;
    }

    @Generated
    public PartitionService getPartitionService() {
        return this.partitionService;
    }

    @Generated
    public TbQueueProducerProvider getProducerProvider() {
        return this.producerProvider;
    }

    @Generated
    public TbQueueAdmin getQueueAdmin() {
        return this.queueAdmin;
    }

    @Generated
    public void setPollDuration(long pollDuration) {
        this.pollDuration = pollDuration;
    }

    @Generated
    public void setPackProcessingTimeout(long packProcessingTimeout) {
        this.packProcessingTimeout = packProcessingTimeout;
    }

    @Generated
    public void setStatsEnabled(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    @Generated
    public void setPrometheusStatsEnabled(boolean prometheusStatsEnabled) {
        this.prometheusStatsEnabled = prometheusStatsEnabled;
    }

    @Generated
    public void setTopicDeletionDelayInSec(int topicDeletionDelayInSec) {
        this.topicDeletionDelayInSec = topicDeletionDelayInSec;
    }

    @Generated
    public void setMgmtThreadPoolSize(int mgmtThreadPoolSize) {
        this.mgmtThreadPoolSize = mgmtThreadPoolSize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbRuleEngineConsumerContext)) {
            return false;
        }
        TbRuleEngineConsumerContext other = (TbRuleEngineConsumerContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPollDuration() != other.getPollDuration()) {
            return false;
        }
        if (this.getPackProcessingTimeout() != other.getPackProcessingTimeout()) {
            return false;
        }
        if (this.isStatsEnabled() != other.isStatsEnabled()) {
            return false;
        }
        if (this.isPrometheusStatsEnabled() != other.isPrometheusStatsEnabled()) {
            return false;
        }
        if (this.getTopicDeletionDelayInSec() != other.getTopicDeletionDelayInSec()) {
            return false;
        }
        if (this.getMgmtThreadPoolSize() != other.getMgmtThreadPoolSize()) {
            return false;
        }
        ActorSystemContext this$actorContext = this.getActorContext();
        ActorSystemContext other$actorContext = other.getActorContext();
        if (this$actorContext == null ? other$actorContext != null : !this$actorContext.equals(other$actorContext)) {
            return false;
        }
        StatsFactory this$statsFactory = this.getStatsFactory();
        StatsFactory other$statsFactory = other.getStatsFactory();
        if (this$statsFactory == null ? other$statsFactory != null : !this$statsFactory.equals(other$statsFactory)) {
            return false;
        }
        TbRuleEngineSubmitStrategyFactory this$submitStrategyFactory = this.getSubmitStrategyFactory();
        TbRuleEngineSubmitStrategyFactory other$submitStrategyFactory = other.getSubmitStrategyFactory();
        if (this$submitStrategyFactory == null ? other$submitStrategyFactory != null : !this$submitStrategyFactory.equals(other$submitStrategyFactory)) {
            return false;
        }
        TbRuleEngineProcessingStrategyFactory this$processingStrategyFactory = this.getProcessingStrategyFactory();
        TbRuleEngineProcessingStrategyFactory other$processingStrategyFactory = other.getProcessingStrategyFactory();
        if (this$processingStrategyFactory == null ? other$processingStrategyFactory != null : !this$processingStrategyFactory.equals(other$processingStrategyFactory)) {
            return false;
        }
        TbRuleEngineQueueFactory this$queueFactory = this.getQueueFactory();
        TbRuleEngineQueueFactory other$queueFactory = other.getQueueFactory();
        if (this$queueFactory == null ? other$queueFactory != null : !this$queueFactory.equals(other$queueFactory)) {
            return false;
        }
        RuleEngineStatisticsService this$statisticsService = this.getStatisticsService();
        RuleEngineStatisticsService other$statisticsService = other.getStatisticsService();
        if (this$statisticsService == null ? other$statisticsService != null : !this$statisticsService.equals(other$statisticsService)) {
            return false;
        }
        TbServiceInfoProvider this$serviceInfoProvider = this.getServiceInfoProvider();
        TbServiceInfoProvider other$serviceInfoProvider = other.getServiceInfoProvider();
        if (this$serviceInfoProvider == null ? other$serviceInfoProvider != null : !this$serviceInfoProvider.equals(other$serviceInfoProvider)) {
            return false;
        }
        PartitionService this$partitionService = this.getPartitionService();
        PartitionService other$partitionService = other.getPartitionService();
        if (this$partitionService == null ? other$partitionService != null : !this$partitionService.equals(other$partitionService)) {
            return false;
        }
        TbQueueProducerProvider this$producerProvider = this.getProducerProvider();
        TbQueueProducerProvider other$producerProvider = other.getProducerProvider();
        if (this$producerProvider == null ? other$producerProvider != null : !this$producerProvider.equals(other$producerProvider)) {
            return false;
        }
        TbQueueAdmin this$queueAdmin = this.getQueueAdmin();
        TbQueueAdmin other$queueAdmin = other.getQueueAdmin();
        return !(this$queueAdmin == null ? other$queueAdmin != null : !this$queueAdmin.equals(other$queueAdmin));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TbRuleEngineConsumerContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pollDuration = this.getPollDuration();
        result = result * 59 + (int)($pollDuration >>> 32 ^ $pollDuration);
        long $packProcessingTimeout = this.getPackProcessingTimeout();
        result = result * 59 + (int)($packProcessingTimeout >>> 32 ^ $packProcessingTimeout);
        result = result * 59 + (this.isStatsEnabled() ? 79 : 97);
        result = result * 59 + (this.isPrometheusStatsEnabled() ? 79 : 97);
        result = result * 59 + this.getTopicDeletionDelayInSec();
        result = result * 59 + this.getMgmtThreadPoolSize();
        ActorSystemContext $actorContext = this.getActorContext();
        result = result * 59 + ($actorContext == null ? 43 : $actorContext.hashCode());
        StatsFactory $statsFactory = this.getStatsFactory();
        result = result * 59 + ($statsFactory == null ? 43 : $statsFactory.hashCode());
        TbRuleEngineSubmitStrategyFactory $submitStrategyFactory = this.getSubmitStrategyFactory();
        result = result * 59 + ($submitStrategyFactory == null ? 43 : $submitStrategyFactory.hashCode());
        TbRuleEngineProcessingStrategyFactory $processingStrategyFactory = this.getProcessingStrategyFactory();
        result = result * 59 + ($processingStrategyFactory == null ? 43 : $processingStrategyFactory.hashCode());
        TbRuleEngineQueueFactory $queueFactory = this.getQueueFactory();
        result = result * 59 + ($queueFactory == null ? 43 : $queueFactory.hashCode());
        RuleEngineStatisticsService $statisticsService = this.getStatisticsService();
        result = result * 59 + ($statisticsService == null ? 43 : $statisticsService.hashCode());
        TbServiceInfoProvider $serviceInfoProvider = this.getServiceInfoProvider();
        result = result * 59 + ($serviceInfoProvider == null ? 43 : $serviceInfoProvider.hashCode());
        PartitionService $partitionService = this.getPartitionService();
        result = result * 59 + ($partitionService == null ? 43 : $partitionService.hashCode());
        TbQueueProducerProvider $producerProvider = this.getProducerProvider();
        result = result * 59 + ($producerProvider == null ? 43 : $producerProvider.hashCode());
        TbQueueAdmin $queueAdmin = this.getQueueAdmin();
        result = result * 59 + ($queueAdmin == null ? 43 : $queueAdmin.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TbRuleEngineConsumerContext(pollDuration=" + this.getPollDuration() + ", packProcessingTimeout=" + this.getPackProcessingTimeout() + ", statsEnabled=" + this.isStatsEnabled() + ", prometheusStatsEnabled=" + this.isPrometheusStatsEnabled() + ", topicDeletionDelayInSec=" + this.getTopicDeletionDelayInSec() + ", mgmtThreadPoolSize=" + this.getMgmtThreadPoolSize() + ", actorContext=" + String.valueOf(this.getActorContext()) + ", statsFactory=" + String.valueOf(this.getStatsFactory()) + ", submitStrategyFactory=" + String.valueOf(this.getSubmitStrategyFactory()) + ", processingStrategyFactory=" + String.valueOf(this.getProcessingStrategyFactory()) + ", queueFactory=" + String.valueOf(this.getQueueFactory()) + ", statisticsService=" + String.valueOf(this.getStatisticsService()) + ", serviceInfoProvider=" + String.valueOf(this.getServiceInfoProvider()) + ", partitionService=" + String.valueOf(this.getPartitionService()) + ", producerProvider=" + String.valueOf(this.getProducerProvider()) + ", queueAdmin=" + String.valueOf(this.getQueueAdmin()) + ")";
    }
}

